% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ztils.R
\name{pca_plot}
\alias{pca_plot}
\title{Principal Component Analysis Plot}
\usage{
pca_plot(group, pcavars, scaled = FALSE, palette = "oslo")
}
\arguments{
\item{group}{The group variable (column)}

\item{pcavars}{The variables to include in the principle component analysis}

\item{scaled}{A boolean (TRUE or FALSE) indicating if the
pcavars are already scaled}

\item{palette}{A color palette to use on the plot, with each
group assigned to a color.}
}
\value{
A plot showing PC1 on the x axis, PC2 on the y axis, colored
by group, with vectors and labels showing the individual pca variables.
}
\description{
This function uses a group, PCA variables, and a scaled boolean to
generate a biplot.using 'ggplot2' and 'scico'.
}
\examples{
pca_plot(iris$Species, iris[,c(1:4)])

pca_plot(iris$Species, iris[,c(1:4)], FALSE, "bilbao")
}
