% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turnTaking.R
\name{turnTaking}
\alias{turnTaking}
\title{Simple conversational turn-taking analysis}
\usage{
turnTaking(inputData, inputType, meetingId, speakerId)
}
\arguments{
\item{inputData}{data.frame output from either processZoomChat or processZoomTranscript}

\item{inputType}{string of either 'chat' or 'transcript'}

\item{meetingId}{string giving the name of the meeting identifier}

\item{speakerId}{string giving the name of the variable with the identity of the speaker}
}
\value{
list of four data.frames giving different levels of analysis for turn taking:
\itemize{
\item rawTurn - This data.frame gives a dataset with a
lagged column so that you could calculate custom metrics
\item aggTurnsDyad - This gives a dyad-level dataset so that
you know whose speech patterns came before whose
\item aggTurnsSpeaker - This gives a speaker-level dataset
with metrics that you could use to assess each given
person's influence on the conversation
\item aggTurnsSpeaker_noself - This is a replication of
the aggTurnsSpeaker dataset, but it excludes turns where
a speaker self-follows (i.e., Speaker A => Speaker A)
}
}
\description{
Generate a very basic analysis of the conversational turntaking in
either a Zoom transcript or a Zoom chat file.
}
\examples{
turn.out = turnTaking(inputData=sample_transcript_processed, 
inputType='transcript', meetingId='batchMeetingId', 
speakerId='userName')

turn.out = turnTaking(inputData=sample_chat_processed, 
inputType='chat', meetingId='batchMeetingId', 
speakerId='userName')

}
