% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndjson.R
\name{read_ndjson_str}
\alias{read_ndjson_str}
\title{Parse an NDJSON string to a data.frame or list}
\usage{
read_ndjson_str(
  x,
  type = c("df", "list"),
  nread = -1,
  nskip = 0,
  nprobe = 100,
  opts = list(),
  ...
)
}
\arguments{
\item{x}{string containing NDJSON}

\item{type}{The type of R object the JSON should be parsed into. Valid
values are 'df' or 'list'.  Default: 'df' (data.frame)}

\item{nread}{Number of records to read. Default: -1 (reads all JSON strings)}

\item{nskip}{Number of records to skip before starting to read. Default: 0
(skip no data)}

\item{nprobe}{Number of lines to read to determine types for data.frame
columns.  Default: 100.   Use \code{-1} to probe entire file.}

\item{opts}{Named list of options for parsing. Usually created by \code{opts_read_json()}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_read_json]{opts_read_json()}}}
}
\value{
NDJSON data read into R as list or data.frame depending
on \code{'type'} argument
}
\description{
If reading as data.frame, each row of NDJSON becomes a row in the data.frame.
If reading as a list, then each row becomes an element in the list.
}
\details{
If parsing NDJSON to a data.frame it is usually better if the json objects
are consistent from line-to-line.  Type inference for the data.frame is done
during initialisation by reading through \code{nprobe} lines.  Warning: if
there is a type-mismatch further into the file than it is probed, then you
will get missing values in the data.frame, or JSON values not captured in
the R data.

No flattening of the namespace is done i.e. nested object remain nested.
}
\examples{
tmp <- tempfile()
json <- write_ndjson_str(head(mtcars))
read_ndjson_str(json, type = 'list')

}
\seealso{
Other JSON Parsers: 
\code{\link{read_json_conn}()},
\code{\link{read_json_file}()},
\code{\link{read_json_raw}()},
\code{\link{read_json_str}()},
\code{\link{read_ndjson_file}()},
\code{\link{read_ndjson_raw}()}
}
\concept{JSON Parsers}
