% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploitation.R
\name{ypr_exploitation}
\alias{ypr_exploitation}
\title{Exploitation Probability}
\usage{
ypr_exploitation(object, pi = ypr_get_par(object))
}
\arguments{
\item{object}{The population or populations.}

\item{pi}{A vector of capture probabilities to calculate the exploitation
probabilities for.}
}
\value{
A vector of exploitation probabilities.
}
\description{
Converts capture probabilities into exploitation probabilities based on the
release and handling mortality probabilities where the probability of
exploitation includes handling mortalities. The calculation assumes that a
released fish cannot be recaught in the same year.
}
\details{
In the case of no release (or 100\% handling mortalities) the exploitation
probability is identical to the capture probability. Otherwise it is less.
}
\examples{
ypr_exploitation(ypr_population(pi = 0.4))
ypr_exploitation(ypr_population(pi = 0.4, rho = 0.6, Hm = 0.2))
}
\seealso{
Other calculate: 
\code{\link{ypr_age_at_length}()},
\code{\link{ypr_length_at_age}()},
\code{\link{ypr_optimize}()},
\code{\link{ypr_yields}()},
\code{\link{ypr_yield}()}
}
\concept{calculate}
