% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.rmd_doc}
\alias{print,rmd_doc-method}
\title{Print Method for rmd_doc}
\usage{
\method{print}{rmd_doc}(x, maxlines = 10, ...)
}
\arguments{
\item{x}{An object of class \code{rmd_doc}.}

\item{maxlines}{An integer value indicating the number of lines used for the
display. Longer documents will be truncated.}

\item{...}{Further arguments passed among methods (not yet in use).}
}
\value{
A display of the resulting R-Markdown document in the console.
}
\description{
Quick display for \code{rmd_doc} objects. This method also defines the way how
objects are displayed in the console.
}
\examples{
## Document without header
my_document <- read_rmd(
  file = file.path(path.package("yamlme"), "taxlistjourney.Rmd"),
  skip_head = TRUE
)
my_document

## Add header using update
my_document <- update(my_document,
  title = "A journey in rOpenSci",
  author = "Miguel Alvarez",
  output = "html_document"
)
my_document

## Header only
my_document$body <- NULL
my_document
}
