% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtwithin.R
\name{within_sd}
\alias{within_sd}
\title{Compute the standard deviation of within-group for a panel data}
\usage{
within_sd(data, variable, id = NULL, t = NULL, na.rm = FALSE)
}
\arguments{
\item{data}{A data.frame or pdata.frame object containing the panel data.}

\item{variable}{The variable for which the standard deviation of within-group effects is calculated.}

\item{id}{(Optional) Name of the individual identifier variable.}

\item{t}{(Optional) Name of the time identifier variable.}

\item{na.rm}{Logical. Should missing values be removed? Default is FALSE.}
}
\value{
The standard deviation of within-group effects.
}
\description{
This function computes the standard deviation of within-group for a panel data.
}
\examples{
# Example using pdata.frame
data("Gasoline", package = "plm")
Gas <- pdata.frame(Gasoline, index = c("country", "year"), drop.index = TRUE)
within_sd(Gas, variable = "lgaspcar")

# Using regular data.frame with id and t specified
data("Crime", package = "plm")
within_sd(Crime, variable = "crmrte", id = "county", t = "year")

}
