% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bookmarks.R
\name{bookmarks}
\alias{bookmarks}
\alias{get_bookmarks}
\alias{get_bookmarks_pdftk}
\alias{get_bookmarks_pdftools}
\alias{set_bookmarks}
\alias{set_bookmarks_pdftk}
\alias{set_bookmarks_gs}
\title{Set/get pdf bookmarks}
\usage{
get_bookmarks(filename, use_names = TRUE)

get_bookmarks_pdftk(filename, use_names = TRUE)

get_bookmarks_pdftools(filename, use_names = TRUE)

set_bookmarks(bookmarks, input, output = input)

set_bookmarks_pdftk(bookmarks, input, output = input)

set_bookmarks_gs(bookmarks, input, output = input)
}
\arguments{
\item{filename}{Filename(s) (pdf) to extract bookmarks from.}

\item{use_names}{If \code{TRUE} (default) use \code{filename} as the names of the result.}

\item{bookmarks}{A data frame with bookmark information with the following columns:\describe{
\item{title}{Title for bookmark (mandatory, character)}
\item{page}{Page number for bookmark (mandatory, integer)}
\item{level}{Level of bookmark e.g. 1 top level, 2 second level, etc. (optional, integer).
If missing will be inferred from \code{count} column else will be assumed to be \code{1L}.}
\item{count}{Number of bookmarks immediately subordinate (optional, integer).
Excludes subordinates of subordinates.
Positive count indicates bookmark should start open while
negative count indicates that this bookmark should start closed.
If missing will be inferred from \code{level} column
and (if specified) the \code{open} column else will be assumed to be \code{0L}.
Note some pdf viewers quietly ignore the initially open/closed feature.}
\item{open}{Whether the bookmark starts open or closed if it has
subordinate bookmarks (optional, logical).
If missing will default to open.
Ignored if the \code{count} column is specified (instead use a negative count
if the bookmark should start closed).
Note some pdf viewers quietly ignore the initially open/closed feature.}
\item{fontface}{Font face of the bookmark (optional, integer).
If \code{NA_character_} or \code{NA_integer_} will be unset (defaults to "plain").
"plain" or 1 is plain, "bold" or 2 is bold, "italic" or 3 is italic,
Note many pdf viewers quietly ignore this feature.}
\item{color}{Color of the bookmark (optional, character).
If \code{NA_character_} will be unset (presumably defaults to "black").
Note many pdf viewers quietly ignore this feature.}
}}

\item{input}{Input pdf filename.}

\item{output}{Output pdf filename.}
}
\value{
\code{get_bookmarks()} returns a list of data frames with bookmark info (see \code{bookmarks} parameter for details about columns) plus "total_pages", "filename", and "title" attributes.
\code{NA} values in the data frame indicates that the backend doesn't report information about this pdf feature.
\code{set_bookmarks()} returns the (output) filename invisibly.
}
\description{
\code{get_bookmarks()} gets pdf bookmarks from a file.
\code{set_bookmarks()} sets pdf bookmarks for a file.
}
\details{
\code{get_bookmarks()} will try to use the following helper functions in the following order:
\enumerate{
\item \code{get_bookmarks_pdftk()} which wraps \code{pdftk} command-line tool
\item \code{get_bookmarks_pdftools()} which wraps \code{\link[pdftools:pdftools]{pdftools::pdf_toc()}}
}

\code{set_bookmarks()} will try to use the following helper functions in the following order:
\enumerate{
\item \code{set_bookmarks_gs()} which wraps \code{ghostscript} command-line tool
\item \code{set_bookmarks_pdftk()} which wraps \code{pdftk} command-line tool
}
}
\section{Known limitations}{

\itemize{
\item \code{get_bookmarks_pdftk()} doesn't report information about bookmarks color, fontface, and whether the bookmarks
should start open or closed.
\item \code{get_bookmarks_pdftools()} doesn't report information about bookmarks page number,
color, fontface, and whether the bookmarks should start open or closed.
\item \code{set_bookmarks_gs()} supports most bookmarks features including color and font face but
only action supported is to view a particular page.
\item \code{set_bookmarks_pdftk()} only supports setting the title, page number, and level of bookmarks.
}
}

\examples{
# Create 2-page pdf using `pdf)` and add some bookmarks to it
if (supports_set_bookmarks() && supports_get_bookmarks() && require("grid", quietly = TRUE)) {
  f <- tempfile(fileext = ".pdf")
  pdf(f, onefile = TRUE)
  grid.text("Page 1")
  grid.newpage()
  grid.text("Page 2")
  invisible(dev.off())

  print(get_bookmarks(f)[[1]])
  \dontshow{cat("\n")}

  bookmarks <- data.frame(title = c("Page 1", "Page 2"), page = c(1, 2))

  set_bookmarks(bookmarks, f)
  print(get_bookmarks(f)[[1]])
  unlink(f)
}
}
\seealso{
\code{\link[=supports_get_bookmarks]{supports_get_bookmarks()}}, \code{\link[=supports_set_bookmarks]{supports_set_bookmarks()}}, \code{\link[=supports_gs]{supports_gs()}}, and \code{\link[=supports_pdftk]{supports_pdftk()}} to detect support for these features.  For more info about the pdf bookmarks feature see \url{https://opensource.adobe.com/dc-acrobat-sdk-docs/library/pdfmark/pdfmark_Basic.html#bookmarks-out}.
}
