% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmlrpc2.R
\name{xmlrpc}
\alias{xmlrpc}
\title{Call the Remote Procedure}
\usage{
xmlrpc(
  url,
  method,
  params = list(),
  handle = NULL,
  opts = list(),
  convert = TRUE,
  useragent = "xmlrpc",
  raise_error = TRUE
)
}
\arguments{
\item{url}{a character string giving the url to the server.}

\item{method}{a character string giving the name of the method 
to be invoked.}

\item{params}{a list containing the parmeters which are added to 
the \code{XML} file sent via the remote procedure call.}

\item{handle}{a object of class \code{"curl_handle"}.}

\item{opts}{a list of options passed to the function \code{"handle_setopt"}.}

\item{convert}{a logical, if convert is \code{TRUE} (default)
the \code{curl} response is converted else it is 
left unchanged.}

\item{useragent}{a character string giving the name of the \code{"User-Agent"}.}

\item{raise_error}{a logical controling the behavior if the status code
of \code{curl_fetch_memory} signals an error.
If \code{raise_error} is \code{TRUE} an error is raised,
if \code{raise_error} is \code{FALSE} 
no error is raised and an object inheriting from
\code{c("fetch_error", error")} is returned.
This object is the return value from \code{curl_fetch_memory}
where just the class \code{c("fetch_error", error")}
is added.}
}
\value{
the reponse of \code{curl} or the response converted to 
        \R objects.
}
\description{
Call a reomte procedure with the \code{XML-RPC} protocol.
}
\examples{
\dontrun{
url <- "https://www.neos-server.org"
xmlrpc(url, "listAllSolvers")
xmlrpc(url, "listSolversInCategory", params = list(category = "socp"))
}

}
