% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml2relational.r
\name{toRelational}
\alias{toRelational}
\title{Converting an XML document into a relational data model}
\usage{
toRelational(
  file,
  prefix.primary = "ID_",
  prefix.foreign = "FKID_",
  keys.unique = TRUE,
  keys.dim = 6
)
}
\arguments{
\item{file}{The XML document to be processed.}

\item{prefix.primary}{A prefix for the tables' primary keys (unique numeric
identifier for a data record/row in the table) . Default is \code{"ID_"}.
The primary key field name will consist of the prefix and the table name.}

\item{prefix.foreign}{A prefix for the tables' foreign keys (). Default is
\code{"FKID_"}. The rest of the foreign key field name will consist of the
prefix and the table name.}

\item{keys.unique}{Defines if the primary keys must be unique across all
tables of the data model or only within the table of which it is the
primary key. Default is \code{TRUE} (unique across all tables).}

\item{keys.dim}{Size of the 'key space' reserved for primary keys. Argument
is a power of ten. Default is \code{6} which means the namespace for
primary keys extends from \code{1} to \code{1 million}.}
}
\value{
A list of standard R dataframes, one for each table of the data model. The
  tables are named for the elements in the XML document.
}
\description{
Imports  an XML document and converts it into a set of
  dataframes each of which represents one table in the data model.
}
\details{
\code{toRelational()} converts the hierarchical XML structure into a
  flat tabular structure with one dataframe for each table in the data model.
  \code{toRelational()} determines automatically which XML elements need to
  be stored in a separate table. The relationship between the nested objects
  in the XML data is recreated in the dataframes with combinations of foreign
  and primary keys. The foreign keys refer to the primary keys that
  \code{toRelational()} creates automatically when adding XML elements to a
  table.
  \tabular{llll}{ Column \tab Type \tab Description \tab Example \cr
  \code{Style} \tab \code{character} \tab Name of the SQL flavor. \tab
  \code{"MySQL"}  \cr \code{NormalField} \tab \code{character} \tab Template
  string for a normal, nullable field. \tab \code{"\%FIELDNAME\% \%DATATYPE\%"}
  \cr \code{NormalFieldNotNull} \tab \code{character} \tab Template string
  for non-nullable field. \tab \code{"\%FIELDNAME\% \%DATATYPE\% NOT NULL"} \cr
  \code{PrimaryKey} \tab \code{character} \tab Template string for the
  definition of a primary key. \tab \code{"PRIMARY KEY (\%FIELDNAME\%)"} \cr
  \code{ForeignKey} \tab \code{character} \tab Template string for the
  definition of a foreign key. \tab \code{"FOREIGN KEY (\%FIELDNAME\%) REFERENCES
  \%REFTABLE\%(\%REFPRIMARYKEY\%)"}  \cr \code{PrimaryKeyDefSeparate} \tab
  \code{logical} \tab Indicates if primary key needs additional definition
  like a any other field.  \tab \code{TRUE}  \cr \code{ForeignKeyDefSeparate}
  \tab \code{logical} \tab Indicates if foreign key needs additional
  definition like a any other field. \tab \code{TRUE} \cr \code{Int} \tab
  \tab \code{character} \tab Name of integer data type. \code{"INT"}  \cr
  \code{Int.MaxSize} \tab \code{numeric} \tab Size limit of integer data
  type.  \tab \code{4294967295}  \cr \code{BigInt} \tab \code{character} \tab
  Name of data type for integers larger than the size limit of the normal
  integer data type. \tab \code{"BIGINT"} \cr \code{Decimal} \tab
  \code{character} \tab Name of data type for floating point numbers. \tab
  \code{"DECIMAL"}  \cr \code{VarChar} \tab \code{character} \tab Name of
  data type for variable-size character fields. \tab \code{"VARCHAR"}  \cr
  \code{VarChar.MaxSize} \tab \code{numeric} \tab Size limit of variable-size
  character data type.\tab \code{65535} \cr \code{Text} \tab \code{character}
  \tab Name of data type for string data larger than the size limit of the
  variable-size character data type. \tab \code{"TEXT"} \cr \code{Date}
  \tab \code{character} \tab Name of data type date data. \tab \code{"DATE"}
  \cr \code{Time} \tab \code{character} \tab Name of data type time data \tab
  \code{"TIME"} \cr \code{Date} \tab \code{character} \tab Name of data
  type for combined date and time data. \tab \code{"TIMESTAMP"}  \cr  }

  In the template strings you can use the following placeholders, as you also
  see from the MySQL example in the table: \enumerate{ \item
  \code{\%FIELDNAME\%}: Name of the field to be defined. \item
  \code{\%DATATYPE\%}: Datatype of the field to be defined. \item
  \code{\%REFTABLE\%}: Table referenced by a foreign key. \item
  \code{\%REFPRIMARYKEY\%}: Name of the primary key field of the table
  referenced by a foreign key. } When you use your own defintion of an SQL
  flavor, then \code{sql.style} must be a one-row dataframe providing the
  fields described in the table above.

  You can use the \code{datatype.func} argument to provide your own function
  to determine how the data type of a field is derived from the values in
  that field. In this case, the values of the columns \code{Int},
  \code{Int.MaxSize}, \code{VarChar}, \code{VarChar.MaxSize}, \code{Decimal}
  and \code{Text} in the \code{sql.style} dataframe are ignored. They are
  used by the built-in mechanism to determine data types. Providing your own
  function allows you to determine data types in a more differentiated way,
  if you like. The function that is provided needs to take a vectors of
  values as its argument and needs to provide the SQL data type of these
  values as a one-element character vector.
}
\examples{

# Find path to custmers.xml example file in package directory
path <- system.file("", "customers.xml", package = "xml2relational")
db <- toRelational(path)

}
\seealso{
Other xml2relational: 
\code{\link{getCreateSQL}()},
\code{\link{getInsertSQL}()},
\code{\link{savetofiles}()}
}
\concept{xml2relational}
