% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGpInitGene.R
\name{xegaGpInitGeneFactory}
\alias{xegaGpInitGeneFactory}
\title{Configure the initialization function of grammar-based genetic programming.}
\usage{
xegaGpInitGeneFactory(method = "InitGene")
}
\arguments{
\item{method}{String specifying the mutation function.}
}
\value{
Initialization function for genes.
}
\description{
\code{xegaGpInitGeneFactory()} implements the 
             creation of a complete derivation tree by one 
             an algorithm  selected 
             by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error), if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "InitGene" returns \code{xegaGpInitGene()}.
             \item "InitGeneGe" returns \code{xegaGpInitGeneGe()}.
             }
}
\examples{
InitGene<-xegaGpInitGeneFactory("InitGene")
gene1<-InitGene(lFxegaGpGene)
InitGene<-xegaGpInitGeneFactory("InitGeneGe")
gene2<-InitGene(lFxegaGpGene)

}
\seealso{
Other Configuration: 
\code{\link{xegaGpCrossoverFactory}()},
\code{\link{xegaGpMutationFactory}()}
}
\concept{Configuration}
