% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BNF.R
\name{compileBNF}
\alias{compileBNF}
\title{Compile a  BNF (Backus-Naur Form) of a context-free grammar.}
\usage{
compileBNF(g, verbose = FALSE)
}
\arguments{
\item{g}{A character string with a BNF.}

\item{verbose}{Boolean. TRUE: Show progress. Default: FALSE.}
}
\value{
A grammar object (list) with the attributes 
        \itemize{
        \item \code{name} (the filename of the grammar),
        \item \code{ST} (symbol table), 
        \item \code{PT} (production table), 
        \item \code{Start} (the start symbol of the grammar), and
        \item \code{SPT} (the short production table).
        }
}
\description{
\code{compileBNF} produces a context-free grammar  
              from its specification in Backus-Naur form (BNF).   
              Warning: No error checking is implemented.
}
\details{
A grammar consists of the symbol table \code{ST}, the production
         table \code{PT}, the start symbol \code{Start}, 
         and the short production
         table \code{SPT}.

The function performs the following steps:
 \enumerate{
 \item Make the symbol table. See \code{\link{makeSymbolTable}}.
 \item Make the production table. See \code{\link{makeProductionTable}}.
 \item Extract the start symbol. See \code{\link{makeStartSymbol}}.
 \item Compile a short production table. See \code{\link{compileShortPT}}.
 \item Return the grammar.}
}
\examples{
g<-compileBNF(booleanGrammar())
g$ST
g$PT
g$Start
g$SPT
}
\references{
Geyer-Schulz, Andreas (1997):
     \emph{Fuzzy Rule-Based Expert Systems and Genetic Machine Learning},
     Physica, Heidelberg. (ISBN:978-3-7908-0830-X)
}
\concept{Grammar Compiler}
