% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{admix_subset}
\alias{admix_subset}
\title{Admixture Data Subsetting}
\usage{
admix_subset(
  data,
  anc = NULL,
  pct = NULL,
  comparison = "greater",
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data}{Data frame containing the admixture data.}

\item{anc}{Vector of ancestry column names to use for pairwise subsetting with percentage vector. Must be of same length as the supplied percentage vector.}

\item{pct}{Vector of percentage values to use for pairwise subsetting with ancestry column name vector. Only ancestries with values above the percentage are kept.}

\item{comparison}{What comparison operator to use for the subsetting. Can either be "greater" or "less"; default is "greater". Also accepts "gt", "lt", ">" and "<".}

\item{quiet}{Whether to print progress or not; default is "FALSE".}

\item{...}{Variable number of additional vectors for subsetting. Looking at the column with argument name, keeps only those observations with values which are elements of the argument vector.}
}
\value{
A subset of the provided data frame.
}
\description{
Subset function optimized for admixture data.
Filters for the percentages of any number of ancestry (K) columns and prints progress. Also allows passing additional arguments to filter columns with.
}
\examples{
# load simulated admixture data
data("xadmixture")

# keep only observations with K1 > 0.1 and K2 > 0.01
subset1 <- admix_subset(xadmixture, 
                        anc = c("K1", "K2"), 
                        pct = c(0.1, 0.01))

# keep only observations with K2 < 0.4 and K3 < 0.1
subset2 <- admix_subset(xadmixture, 
                        anc = c("K2", "K3"), 
                        pct = c(0.4, 0.1), 
                        comparison = "less")

# keep only observations with values "GBR" or "FRA" in column 
# "country" and values "lorem" or "dolor" in column "species"
subset3 <- admix_subset(xadmixture, 
                        country = c("GBR", "FRA"), 
                        species = c("lorem", "dolor"))

# keep only observations with K1 > 0.1 and K4 < 0.3, 
# without printing progress; subsets can be chained 
# using the pipe operator from package `magrittr` 
library(magrittr)
subset4 <- admix_subset(xadmixture, 
                        anc = "K1", 
                        pct = 0.1, 
                        quiet = TRUE) \%>\% 
 admix_subset(anc = "K4", 
              pct = 0.3, 
              comparison = "less", 
              quiet = TRUE)
}
