% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMI2.R
\name{MCMI2}
\alias{MCMI2}
\title{Monte Carlo Confidence Intervals for Multiple Imputation SEM Models}
\usage{
MCMI2(
  sem_model,
  imputations,
  R = 20000L,
  alpha = c(0.001, 0.01, 0.05),
  decomposition = "eigen",
  pd = TRUE,
  tol = 1e-06,
  seed = NULL,
  estimator = "ML",
  se = "standard",
  missing = "listwise"
)
}
\arguments{
\item{sem_model}{A character string specifying the SEM model syntax.}

\item{imputations}{A list of data frames, where each data frame represents an imputed dataset.}

\item{R}{An integer specifying the number of Monte Carlo samples. Default is \code{20000L}.}

\item{alpha}{A numeric vector specifying significance levels for the confidence intervals. Default is \code{c(0.001, 0.01, 0.05)}.}

\item{decomposition}{A character string specifying the decomposition method for the covariance matrix.
Default is \code{"eigen"}. Options include \code{"chol"}, \code{"eigen"}, or \code{"svd"}.}

\item{pd}{A logical value indicating whether to ensure positive definiteness of the covariance matrix. Default is \code{TRUE}.}

\item{tol}{A numeric value specifying the tolerance for positive definiteness checks. Default is \code{1e-06}.}

\item{seed}{An optional integer specifying the random seed for reproducibility. Default is \code{NULL}.}

\item{estimator}{A character string specifying the estimator for SEM fitting. Default is \code{"ML"} (Maximum Likelihood).}

\item{se}{A character string specifying the type of standard errors to compute. Default is \code{"standard"}.}

\item{missing}{A character string specifying the method for handling missing data in SEM fitting. Default is \code{"listwise"}.}
}
\value{
An object of class \code{semmcci} containing:
\itemize{
\item \code{call}: The matched function call.
\item \code{args}: A list of input arguments.
\item \code{thetahat}: The pooled parameter estimates.
\item \code{thetahatstar}: Monte Carlo samples for parameter estimates.
\item \code{fun}: The name of the function (\code{"MCMI2"}).
}
}
\description{
Computes Monte Carlo confidence intervals (MCCI) for structural equation models (SEM)
fitted to multiple imputed datasets. This function integrates SEM fitting across imputed datasets,
pools the results, and generates confidence intervals through Monte Carlo sampling.
}
\details{
This function is designed for SEM models that require multiple imputation to handle missing data.
It performs the following steps:
\itemize{
\item \strong{SEM Fitting}: Fits the specified SEM model to each imputed dataset using \code{\link[lavaan:sem]{lavaan::sem()}}.
\item \strong{Pooling Results}: Combines parameter estimates and covariance matrices across imputations
using Rubin's rules.
\item \strong{Monte Carlo Sampling}: Generates Monte Carlo samples based on the pooled estimates and covariance matrices,
and calculates confidence intervals for model parameters.
}

This function supports custom estimators, handling of missing data, and precision adjustments for
Monte Carlo sampling. It is particularly useful for mediation analysis or complex SEM models
where missing data are addressed using multiple imputation.
}
\examples{
# Example SEM model
sem_model <- "
  Ydiff ~ b1 * M1diff + cp * 1
  M1diff ~ a1 * 1
  indirect := a1 * b1
  total := cp + indirect
"

# Example imputed datasets
imputations <- list(
  data.frame(M1diff = rnorm(100), Ydiff = rnorm(100)),
  data.frame(M1diff = rnorm(100), Ydiff = rnorm(100))
)

# Compute Monte Carlo confidence intervals
result <- MCMI2(
  sem_model = sem_model,
  imputations = imputations,
  R = 1000,
  alpha = c(0.05, 0.01),
  seed = 123
)
}
\seealso{
\code{\link[lavaan:sem]{lavaan::sem()}}, \code{\link[semmcci:MC]{semmcci::MC()}}, \code{\link[semmcci:MCStd]{semmcci::MCStd()}}
}
