% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_types.R
\name{xl_formula}
\alias{xl_formula}
\alias{xl_hyperlink}
\title{Excel Types}
\usage{
xl_formula(x)

xl_hyperlink(url, name = NULL)
}
\arguments{
\item{x}{character vector to be interpreted as formula}

\item{url}{character vector of URLs}

\item{name}{character vector of friendly names}
}
\description{
Create special column types to write to a spreadsheet
}
\examples{
df <- data.frame(
  name = c("UCLA", "Berkeley", "Jeroen"),
  founded = c(1919, 1868, 2030),
  website = xl_hyperlink(c("http://www.ucla.edu", "http://www.berkeley.edu", NA), "homepage")
)
df$age <- xl_formula('=(YEAR(TODAY()) - INDIRECT("B" & ROW()))')
write_xlsx(df, 'universities.xlsx')

# cleanup
unlink('universities.xlsx')
}
\concept{writexl}
