% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{link_ccm}
\alias{link_ccm}
\title{Get CRSP-Compustat linking table}
\usage{
link_ccm(
  wrds,
  linktype = c("LC", "LU", "LS"),
  linkprim = c("P", "C"),
  n = Inf,
  lazy = FALSE
)
}
\arguments{
\item{wrds}{A \code{DBIConnection} object returned by \code{\link[=wrds_connect]{wrds_connect()}}.}

\item{linktype}{Character vector. Types of links to include.
Defaults to \code{c("LC", "LU", "LS")}:
\itemize{
\item \code{"LC"}: Link confirmed by Compustat
\item \code{"LU"}: Link unconfirmed (valid but less certain)
\item \code{"LS"}: Link valid for secondary securities
}}

\item{linkprim}{Character vector. Link primacy filters.
Defaults to \code{c("P", "C")}:
\itemize{
\item \code{"P"}: Primary link identified by Compustat
\item \code{"C"}: Primary link identified by CRSP
}}

\item{n}{Maximum number of rows to return. Defaults to \code{Inf} (all rows).
Use a smaller value (e.g., \code{n = 100}) to preview data before downloading
the full table.}

\item{lazy}{If \code{TRUE}, returns a lazy \code{tbl} instead of collecting.
Defaults to \code{FALSE}.}
}
\value{
A tibble with columns:
\describe{
\item{gvkey}{Compustat company identifier}
\item{permno}{CRSP permanent security identifier}
\item{linkdt}{Start date of the link}
\item{linkenddt}{End date of the link (missing values replaced with max date)}
\item{linktype}{Type of link}
\item{linkprim}{Link primacy}
}
}
\description{
Downloads the CCM (CRSP-Compustat Merged) linking table that maps
CRSP PERMNOs to Compustat GVKEYs with valid date ranges.
}
\details{
The linking table comes from \code{crsp.ccmxpf_lnkhist}. Missing \code{linkenddt}
values indicate ongoing links and are replaced with the maximum date in the
table for easier date-range joins.

To use the link, join on \code{gvkey} and ensure your observation date falls
within the \code{linkdt} to \code{linkenddt} range.
}
\examples{
\dontrun{
wrds <- wrds_connect()
ccm <- link_ccm(wrds)

# Join with Compustat data
compustat <- get_compustat(wrds)
compustat |>
  dplyr::inner_join(ccm, by = dplyr::join_by(gvkey)) |>
  dplyr::filter(datadate >= linkdt, datadate <= linkenddt)

wrds_disconnect(wrds)
}
}
\references{
Ian Gow, \emph{Financial Accounting Research}, Chapter on Identifiers:
\url{https://iangow.github.io/far_book/identifiers.html}
}
\seealso{
\code{\link[=get_compustat]{get_compustat()}}
}
