% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragmentSeq.R
\name{.termPepCut}
\alias{.termPepCut}
\title{Make Named Character Vector Of Sequential Terminal Fragments}
\usage{
.termPepCut(
  pe,
  mi,
  ma = 1000,
  se1 = ".",
  se2 = "-",
  mainName = NULL,
  sepNC = FALSE,
  indexOffs = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{pe}{(character, length=1) s}

\item{mi}{(integer) min number of AA residues for considering peptide fragments; should be <= length(pe) (otherwise the full length of 'pe' ALWAYS returned !)}

\item{ma}{(integer) max number of AA residues for considering peptide fragments}

\item{se1}{(character, length=1) separators for adding numbers to specify partial/fragment locations}

\item{se2}{(character, length=1) separators for adding numbers to specify partial/fragment locations}

\item{mainName}{(character, length=1)}

\item{sepNC}{(logical) if 'TRUE', separate N-terminal, C-terminal and internal fragments in list}

\item{indexOffs}{(logical) offset to add for custom numbering in names (numeric, length=1), ie '1' will already increase by +1}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a numeric vector with mass(es) and sequence in name(s)
}
\description{
Make named character vector of sequential terminal fragments
}
\examples{
## Ubiquitin example
P0CG48 <- "MQIFVKTLTGKTITLEVEPSDTIENVKAKIQDKEGIPPDQQRLIFAGKQLEDGRTLSDYNIQKESTLHLVLRLRGG"  
.termPepCut(P0CG48, mi=3, ma=12 ,sepNC=TRUE, mainName="P0CG48")

}
\seealso{
\code{\link{makeFragments}};   \code{\link[wrProteo]{convAASeq2mass}}
}
