% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchLinesAtGivenSlope.R
\name{.insp1dimByClustering}
\alias{.insp1dimByClustering}
\title{Segment (1-dim vector) 'dat' into clusters}
\usage{
.insp1dimByClustering(
  dat,
  automClu = TRUE,
  cluChar = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{matrix or data.frame, main input}

\item{automClu}{(logical) run atomatic clustering}

\item{cluChar}{(logical) to display cluster characteristics}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns clustering (class index) or (if 'cluChar'=TRUE) list with clustering and cluster-characteristics
}
\description{
This function allows aegmenting (1-dim vector) 'dat' into clusters.
If 'automClu=TRUE ..' first try automatic clustering, if too few clusters, run km with length(dat)^0.3 clusters
This function requires the package NbClust to be installed.
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
}
\seealso{
\code{\link{searchLinesAtGivenSlope}}
}
