% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjBy2ptReg.R
\name{adjBy2ptReg}
\alias{adjBy2ptReg}
\title{Linear rescaling of numeric vertor or matrix}
\usage{
adjBy2ptReg(
  dat,
  lims,
  regrTo = c(0.1, 0.9),
  refLines = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{numeric vector, matrix or data.frame}

\item{lims}{(list, length=2) should be list giving limits (list(lo=c(min,max),hi=c(min,max)) in data allowing identifying which points will be used for determining slope & offset}

\item{regrTo}{(numeric, length=2) to which characteristics data should be regressed}

\item{refLines}{(NULL or integer) optional subselection of lines of dat (will be used internal as refDat)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) display additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a matrix (of same dimensions as inlut matrix) with normalized values
}
\description{
\code{adjBy2ptReg} takes data within window defined by 'lims' and determines linear transformation so that these points get the regression characteristics 'regrTo', 
all other points (ie beyond the limits) will follow the same transformation.
In other words, this function performs 'linear rescaling', by adjusting (normalizing) the vector 'dat' by linear regression so that points falling in 'lims'
(list with upper & lower boundaries) will end up as 'regrTo'.
}
\examples{
set.seed(2016); dat1 <- round(runif(50,0,100),1)
## extreme values will be further away :
adjBy2ptReg(dat1,lims=list(c(5,9), c(60,90)))
plot(dat1, adjBy2ptReg(dat1, lims=list(c(5,9),c(60,90))))
}
\seealso{
\code{\link{normalizeThis}}
}
