% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossword.R
\name{crossword}
\alias{crossword}
\title{Create a crossword puzzle}
\usage{
crossword(words, clues, r = 50, c = 50, method = c("optimal", "random"))
}
\arguments{
\item{words}{a vector of words (character/vector)}

\item{clues}{a vector a clues (character/vector)}

\item{r}{number of rows (numeric/scalar)}

\item{c}{number of columns (numeric/scalar)}

\item{method}{generate puzzle using 'optimal' or 'random' word order, where
the optimal order will place words with the most overlap first}
}
\value{
crossword object
}
\description{
Create a crossword puzzle
}
\examples{
# Example 1 ----
words <- c("apple", "pear", "banana")
clues <- c("red fruit", "bartlett", "green then yellow")
x <- crossword(words, clues)
plot(x, solution = TRUE)

# Example 2 ---
dat <-
dplyr::tribble(
  ~word,   ~clue,
  "dog",   "Bark. Bark. Bark.",
  "cat",   "Purrr",
  "horse", "Neighhhhh",
  "frog",  "Ribbit Ribbit",
  "cow",   "Moooooooo",
  "fox",   "Nee Nee Nee (What does the ____ say?)",
  "sheep", "Bleat",
  "snake", "Hissss",
  "duck",  "Quack",
  "bird",  "Chirp"
)
ex2 <- crossword(words = dat$word, clues = dat$clue, r = 40, c = 40)
plot(ex2, solution = TRUE, clues = TRUE)

}
