% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/white_test.R
\name{white_test}
\alias{white_test}
\title{This function performs a White's Test for heteroskedasticity (White, H. (1980))}
\usage{
white_test(model)
}
\arguments{
\item{model}{An object of class \code{\link[stats]{lm}}}
}
\value{
AA list with class \code{white_test} containing:\tabular{ll}{
   \code{w_stat} \tab The value of the test statistic \cr
   \tab \cr
   \code{p_value} \tab The p-value of the test \cr
   \tab \cr
}
}
\description{
White's test is a statistical test that determines whether the variance of the residuals in a regression model is constant.
}
\details{
The approach followed is the one detailed at Wooldridge, 2012, p. 275. The fitted values from the original model are:

\deqn{\widehat{y_i} = \widehat{\beta_0} + \widehat{\beta_1}x_{i1} + ... + \widehat{\beta_k}x_{ik}}

Heteroscedasticity could be tested as a linear regression of the squared residuals against the fitted values:

\deqn{\widehat{u^2} = \delta_0 + \delta_1\widehat{y} + \delta_2\widehat{y^2} + error}

The null hypothesis states that \eqn{\delta_1 = \delta_2 = 0} (homoskedasticity). The test statistic
is defined as:

\deqn{LM = nR^2}

where \eqn{R^2} is the R-squared value from the regression of \eqn{u^2}.
}
\examples{
# Define a dataframe with heteroscedasticity
n <- 100
y <- 1:n
sd <- runif(n, min = 0, max = 4)
error <- rnorm(n, 0, sd*y)
X <- y + error
df <- data.frame(y, X)
# OLS model
fit <- lm(y ~ X, data = df)
# White's test
white_test(fit)
}
\references{
White, H. (1980). A Heteroskedasticity-Consistent Covariance Matrix Estimator
and a Direct Test for Heteroskedasticity. Econometrica, 48(4), 817-838.

Wooldridge, Jeffrey M., 1960-. (2012). Introductory econometrics : a modern approach. Mason, Ohio :
South-Western Cengage Learning,
}
\seealso{
\code{\link[stats]{lm}}
}
