% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\encoding{UTF-8}
\name{plot_prob}
\alias{plot_prob}
\alias{plot_prob.wt_cdf_estimation}
\alias{plot_prob.wt_model}
\title{Probability Plotting Method for Univariate Lifetime Distributions}
\usage{
plot_prob(x, ...)

\method{plot_prob}{wt_cdf_estimation}(
  x,
  distribution = c("weibull", "lognormal", "loglogistic", "sev", "normal", "logistic",
    "exponential"),
  title_main = "Probability Plot",
  title_x = "Characteristic",
  title_y = "Unreliability",
  title_trace = "Sample",
  plot_method = c("plotly", "ggplot2"),
  ...
)

\method{plot_prob}{wt_model}(
  x,
  title_main = "Probability Plot",
  title_x = "Characteristic",
  title_y = "Unreliability",
  title_trace = "Sample",
  plot_method = c("plotly", "ggplot2"),
  ...
)
}
\arguments{
\item{x}{A tibble with class \code{wt_cdf_estimation} returned by \link{estimate_cdf}
or a list with class \code{wt_model} returned by \link{rank_regression}, \link{ml_estimation},
\link{mixmod_regression} or \link{mixmod_em}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{distribution}{Supposed distribution of the random variable.}

\item{title_main}{A character string which is assigned to the main title.}

\item{title_x}{A character string which is assigned to the title of the x axis.}

\item{title_y}{A character string which is assigned to the title of the y axis.}

\item{title_trace}{A character string which is assigned to the legend trace.}

\item{plot_method}{Package, which is used for generating the plot output.}
}
\value{
A plot object containing the probability plot.
}
\description{
This function is used to apply the graphical technique of probability
plotting. It is either applied to the output of \link{estimate_cdf}
(\code{plot_prob.wt_cdf_estimation}) or to the output of a mixture model from
\link{mixmod_regression} / \link{mixmod_em} (\code{plot_prob.wt_model}). Note that in the
latter case no distribution has to be specified because it is inferred from
the model.
}
\details{
If \code{x} was split by \link{mixmod_em}, \link{estimate_cdf} with method \code{"johnson"} is
applied to subgroup-specific data. The calculated plotting positions are
shaped according to the determined split in \link{mixmod_em}.

In \link{mixmod_regression} a maximum of three subgroups can be determined and thus
being plotted. The intention of this function is to give the user a hint for
the existence of a mixture model. An in-depth analysis should be done afterwards.

For \code{plot_method == "plotly"} the marker label for x and y are determined by
the first word provided in the argument \code{title_x} and \code{title_y} respectively,
i.e. if \code{title_x = "Mileage in km"} the x label of the marker is "Mileage".
The name of the legend entry is a combination of the \code{title_trace} and the
number of determined subgroups (if any). If \code{title_trace = "Group"} and the
data has been split in two groups, the legend entries are "Group: 1" and
"Group: 2".
}
\examples{
# Reliability data:
data <- reliability_data(
  alloy,
  x = cycles,
  status = status
)

# Probability estimation:
prob_tbl <- estimate_cdf(
  data,
  methods = c("johnson", "kaplan")
)

# Example 1 - Probability Plot Weibull:
plot_weibull <- plot_prob(prob_tbl)

# Example 2 - Probability Plot Lognormal:
plot_lognormal <- plot_prob(
  x = prob_tbl,
  distribution = "lognormal"
)

## Mixture identification
# Reliability data:
data_mix <- reliability_data(
  voltage,
  x = hours,
  status = status
)

prob_mix <- estimate_cdf(
  data_mix,
  methods = c("johnson", "kaplan")
)

# Example 3 - Mixture identification using mixmod_regression:
mix_mod_rr <- mixmod_regression(prob_mix)

plot_mix_mod_rr <- plot_prob(x = mix_mod_rr)

# Example 4 - Mixture identification using mixmod_em:
mix_mod_em <- mixmod_em(data_mix)

plot_mix_mod_em <- plot_prob(x = mix_mod_em)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
reliability data, New York: Wiley series in probability and statistics, 1998
}
