% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_2D.R
\name{wave.variance.2d}
\alias{wave.variance.2d}
\title{Wavelet Analysis of Images}
\usage{
wave.variance.2d(x, p = 0.025)
}
\arguments{
\item{x}{image}

\item{p}{(one minus the) two-sided p-value for the confidence interval}
}
\value{
Data frame with 3J+1 rows.
}
\description{
Produces an estimate of the multiscale variance with approximate 
confidence intervals using the 2D MODWT.
}
\details{
The wavelet variance is basically the average of the squared wavelet 
coefficients across each scale and direction of an image. As shown 
in Mondal and Percival (2012), the wavelet variance is a 
scale-by-scale decomposition of the variance for a stationary spatial
process, and certain non-stationary spatial processes.
}
\references{
Mondal, D. and D. B. Percival (2012). Wavelet variance 
analysis for random fields on a regular lattice. \emph{IEEE 
Transactions on Image Processing} \bold{21}, 537–549.
}
\author{
B. Whitcher
}
