% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heuristics.R
\name{midpoint_heuristic}
\alias{midpoint_heuristic}
\title{Midpoint Heuristic for the Picker’s Route Designation}
\usage{
midpoint_heuristic(arcs)
}
\arguments{
\item{arcs}{A data frame or matrix representing the arcs (edges) in the warehouse. The arcs should have columns `x_from`, `x_to`, `y_from`, and `y_to`, which represent the coordinates of the connections between aisles and shelves.}
}
\value{
A matrix of arcs after applying the midpoint heuristic, with edges that cross the warehouse's middle line excluded and I/O points added.
}
\description{
This heuristic generates a return route solution for the picker’s route designation in a warehouse by removing arcs at the top row of the warehouse and duplicating the remaining arcs to form a round trip.
}
\details{
The heuristic first determines the warehouse height and the reduced width by examining the arcs. For each aisle, the edges are split and removed if they cross beyond the midpoint of the warehouse's height. Finally, I/O points are added, and any empty final aisles are deleted.
}
\examples{

coordinates <- matrix(c(1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5,
                       0, 4, 11, 0, 10, 11, 0, 1, 5, 11, 0, 4, 11, 0, 4,
                       11), ncol = 2, byrow = FALSE,
                       dimnames = list(NULL, c("x", "y")))
midpoint_heuristic(create_arcs(coordinates))

}
\references{
Dmytrów, K. (2022). Analytical and simulation determination of order picking time in a low storage warehouse for shared storage systems. Operations Research and Decisions, 32(2), 34–51. \doi{10.37190/ord220203}

Le-Duc, T. (2005). Design and Control of Efficient Order. Erasmus Research Institute of Management (ERIM).

Tarczyński, G. (2012). Analysis of the Impact of Storage Parameters and the Size of Orders on the Choice of the Method for Routing Order Picking. Operations Research and Decisions, 22(4), 105–120. \doi{10.5277/ord120406}
}
\seealso{
\code{\link{return_heuristic}}, \code{\link{sshape_heuristic}}
}
\author{
Krzysztof Dmytrów \email{krzysztof.dmytrow@usz.edu.pl} [aut] \href{https://orcid.org/0000-0001-7657-6063}{ORCID: 0000-0001-7657-6063}

Andrzej Dudek \email{andrzej.dudek@ue.wroc.pl} [aut, cre] \href{https://orcid.org/0000-0002-4943-8703}{ORCID: 0000-0002-4943-8703}
}
