% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_users.R
\name{get_users}
\alias{get_users}
\title{Get all users from an account}
\usage{
get_users(
  canvas,
  account_id = "self",
  per_page = 100,
  search_term = NULL,
  enrollment_type = NULL,
  sort = NULL,
  order = NULL,
  include_deleted_users = NULL,
  uuids = NULL,
  include = NULL
)
}
\arguments{
\item{canvas}{An object containing the Canvas API key and base URL, obtained through the \code{canvas_authenticate} function.}

\item{account_id}{The ID of the account. Defaults to "self" for the current user's account.}

\item{per_page}{The number of entries to show per page. Default is 100.}

\item{search_term}{Optional. The partial name or full ID of the users to match and return in the results list. Must be at least 3 characters.}

\item{enrollment_type}{Optional. When set, only return users enrolled with the specified course-level base role. Possible values: 'student', 'teacher', 'ta', 'observer', or 'designer'.}

\item{sort}{Optional. The column to sort results by. Possible values: 'username', 'email', 'sis_id', 'integration_id', 'last_login', 'id'.}

\item{order}{Optional. The order to sort the given column by. Possible values: 'asc', 'desc'.}

\item{include_deleted_users}{Optional. When set to TRUE, returns users who have deleted pseudonyms for the context.}

\item{uuids}{Optional. A vector of UUIDs. When set, only return users with the specified UUIDs. UUIDs after the first 100 are ignored.}

\item{include}{Optional. A vector of additional information to include. Possible values include: "email", "enrollments", "avatar_url", "bio", "last_login", "time_zone", "locale", "uuid".}
}
\value{
A data frame containing the users matching the specified criteria.
}
\description{
Retrieves users from a specific account in the Canvas LMS API with optional filtering and pagination.
}
\examples{
\dontrun{
# Authenticate with Canvas
canvas <- canvas_authenticate()

# Get all users from the default account
users <- get_users(canvas)

# Get users with a search term
users <- get_users(canvas, search_term = "John")

# Get users with email addresses included
users <- get_users(canvas, include = c("email", "enrollments"))
}
}
