% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_duplicates.R
\name{check_duplicates}
\alias{check_duplicates}
\title{Check for Duplicate Rows in Selected Columns}
\usage{
check_duplicates(data, columns)
}
\arguments{
\item{data}{A data frame.}

\item{columns}{A character vector of column names.}
}
\value{
A logical value indicating whether the number of rows in the original data frame is the same as the number of rows in the data frame with duplicate rows removed.
}
\description{
This function checks if there are any duplicate rows in the specified columns of a data frame.
It prints the unique rows and returns a boolean indicating whether the number of rows in the original data frame is the same as the number of rows in the data frame with duplicate rows removed.
}
\examples{
# Create a data frame
df <- data.frame(a = c(1, 2, 3, 1), b = c(4, 5, 6, 4), c = c(7, 8, 9, 7))
# Check for duplicate rows in the first two columns
check_duplicates(df, c("a", "b"))

}
