% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vue.R
\name{vue-shiny}
\alias{vue-shiny}
\alias{vueOutput}
\alias{renderVue}
\alias{vue3Output}
\alias{renderVue3}
\title{Shiny bindings for vue}
\usage{
vueOutput(outputId, width = "100\%", height = "400px")

renderVue(expr, env = parent.frame(), quoted = FALSE)

vue3Output(outputId, width = "100\%", height = "400px")

renderVue3(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a vue}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using vue within Shiny
applications and interactive Rmd documents.

Output and render functions for using 'vue 3' within Shiny
applications and interactive Rmd documents.
}
\examples{
if(interactive()) {

  library(shiny)
  library(vueR)

  ui <- tagList(
    tags$div(id="app-3",
      tags$p("v-if"="seen", "Now you see me")
    ),
    vue3Output('vue1')
  )

  server <- function(input, output, session) {
    output$vue1 <- renderVue3({
      vue3(
        list(
          el = '#app-3',
          data = list(seen = TRUE),
          mounted = htmlwidgets::JS("
            function() {
              var that = this;
              setInterval(function(){that.seen=!that.seen},1000);
            }
          "),
          watch = list(
            seen = htmlwidgets::JS("function() {Shiny.setInputValue('seen',this.seen)}")
          )
        )
      )
    })

    # show that Shiny input value is being updated
    observeEvent(input$seen, {print(input$seen)})
  }

  shinyApp(ui, server)

}
}
