% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{transectPlot}
\alias{transectPlot}
\title{Plot vertical sample}
\usage{
transectPlot(
  rast = NULL,
  sampleAxis = "lon",
  axisValue = NA,
  scaleRange = NA,
  plotLegend = TRUE,
  depthLim = as.numeric(max(names(rast))),
  transRange = c(-90, 90),
  transTicks = 20,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{rast}{A multilayer \code{SpatRaster} object, with names
corresponding to the z coordinate represented by the layer.
These names must be interpretable by \code{as.numeric}.}

\item{sampleAxis}{Specifies whether a latitudinal ("lat") or
longitudinal ("long") transect is desired.}

\item{axisValue}{Numeric value specifying transect postion.}

\item{scaleRange}{A numeric vector of length 2, specifying
the range that should be used for the plot color scale.}

\item{plotLegend}{\code{logical}, controls whether legend is plotted.}

\item{depthLim}{A single vector of class \code{numeric}. How deep
should the plot go?}

\item{transRange}{A \code{numeric} vector of lenghth 2. How far
along the transect should be plotted?}

\item{transTicks}{\code{numeric}, spacing between breaks on x axis.}

\item{verbose}{\code{logical}. Switching to \code{FALSE} mutes message
alerting user if input \code{rast} values exceed specified \code{scaleRange}.}

\item{...}{Additional optional arguments to pass to \code{viridis}.}
}
\value{
A \code{ggplot} showing a vertical slice through the \code{SpatRaster}.
}
\description{
Plots cell values along a vertical transect
}
\note{
Only unprojected \code{SpatRaster} files are supported.
}
\examples{
library(terra)

rast1 <- rast(ncol=10, nrow=10)
values(rast1) <- rep(0:3, 50)

rast2 <- rast(ncol=10, nrow=10)
values(rast2) <- c(rep(0, 50), rep(1,25), rep(2,25))

rast3 <- rast(ncol=10, nrow=10)
values(rast3) <- rep(c(1,3,2,1), 25)

distBrick <- c(rast1, rast2, rast3)
names(distBrick) <- c(0:2)

transectPlot(distBrick, depthLim = 3)


}
\keyword{plotting}
