% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tdur.R
\name{get_tdur}
\alias{get_tdur}
\title{Time duration}
\usage{
get_tdur(x)
}
\arguments{
\item{x}{A data frame in RTTM standard. See 'voice::read_rttm'.}
}
\value{
Numeric vector containing the time duration in seconds.
}
\description{
Get time duration from a data frame in RTTM standard.
}
\examples{
library(voice)

url0 <- 'https://raw.githubusercontent.com/filipezabala/voiceAudios/main/rttm/sherlock0.rttm'
download.file(url0, destfile = paste0(tempdir(), '/sherlock0.rttm'))

rttm <- voice::read_rttm(tempdir())
(gtd <- voice::get_tdur(rttm$sherlock0.rttm))
class(gtd)
}
