% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symlink_tool.R
\name{SLT}
\alias{SLT}
\title{SymlinkTool R6 class}
\description{
Class for lightweight file-system level data versioning, logs
  and reports without need for a database.
}
\examples{

## ------------------------------------------------
## Method `SLT$new`
## ------------------------------------------------


try(SLT$new()) # call with no arguments to see instructions
# Tool will not instantiate on Windows unless running with Admin permissions
# - requirement for symlink creation on Windows
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Symlink_Tool-new}{\code{SLT$new()}}
\item \href{#method-Symlink_Tool-return_dictionaries}{\code{SLT$return_dictionaries()}}
\item \href{#method-Symlink_Tool-return_dynamic_fields}{\code{SLT$return_dynamic_fields()}}
\item \href{#method-Symlink_Tool-mark_best}{\code{SLT$mark_best()}}
\item \href{#method-Symlink_Tool-mark_keep}{\code{SLT$mark_keep()}}
\item \href{#method-Symlink_Tool-mark_remove}{\code{SLT$mark_remove()}}
\item \href{#method-Symlink_Tool-unmark}{\code{SLT$unmark()}}
\item \href{#method-Symlink_Tool-roundup_best}{\code{SLT$roundup_best()}}
\item \href{#method-Symlink_Tool-roundup_keep}{\code{SLT$roundup_keep()}}
\item \href{#method-Symlink_Tool-roundup_remove}{\code{SLT$roundup_remove()}}
\item \href{#method-Symlink_Tool-roundup_unmarked}{\code{SLT$roundup_unmarked()}}
\item \href{#method-Symlink_Tool-roundup_by_date}{\code{SLT$roundup_by_date()}}
\item \href{#method-Symlink_Tool-get_common_new_version_name}{\code{SLT$get_common_new_version_name()}}
\item \href{#method-Symlink_Tool-make_new_version_folder}{\code{SLT$make_new_version_folder()}}
\item \href{#method-Symlink_Tool-make_new_log}{\code{SLT$make_new_log()}}
\item \href{#method-Symlink_Tool-delete_version_folders}{\code{SLT$delete_version_folders()}}
\item \href{#method-Symlink_Tool-make_reports}{\code{SLT$make_reports()}}
\item \href{#method-Symlink_Tool-clone}{\code{SLT$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-new"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-new}{}}}
\subsection{Method \code{new()}}{
Initialize the SymlinkTool object - an R6 class

The constructor function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$new(
  user_root_list = NULL,
  user_central_log_root = NULL,
  schema_repair = TRUE,
  verbose = TRUE,
  verbose_startup = FALSE,
  csv_reader = "fread_quiet",
  timezone = Sys.timezone()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user_root_list}}{[list] Named list of root directories for
pipeline outputs. This is where `version_name` folders live - these
are iterative runs of an analysis pipeline.}

\item{\code{user_central_log_root}}{[path] Root directory for the central log.
If you have multiple roots in the `user_root_list`, you probably want
the central log to live one level above those roots.}

\item{\code{schema_repair}}{[logical] Default `TRUE`.  If `TRUE`, the tool
will attempt to repair any schema mismatches it finds in the logs
when reading and writing e.g. add new columns if the tool schema has
columns that existing logs do not. If `FALSE`, the tool will stop and
throw an error if it finds a schema mismatch.}

\item{\code{verbose}}{[lgl: default TRUE] control message verbosity - if TRUE,
standard message, if FALSE, warn only if something is irregular.}

\item{\code{verbose_startup}}{[lgl] see start up warnings, if relevant?}

\item{\code{csv_reader}}{[chr] The CSV reader to use (also assigns matching
  CSV writer). CAUTION: DO NOT USE `data.table::fread` if you have any
  quotation marks (") in log comments (these lead to exploding series
  of quotations). https://github.com/Rdatatable/data.table/issues/4779.
  Otherwise use `read.csv[2]`. Options:
\itemize{
 \item{fread_quiet - `data.table::fread` and suppress warnings (default)}
 \item{fread       - `data.table::fread`}
 \item{read.csv    - `utils::read.csv` - safer}
 \item{read.csv2   - `utils::read.csv2` - safer, comma as decimal point, semicolon as field separator}
}}

\item{\code{timezone}}{[chr] Default `America/Los_Angeles`.  The timezone to
use for datestamps in logs. Must be a valid `OlsonNames()` string.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[symlink_tool] A symlink tool object.  You can instantiate
  a.k.a. create multiple objects, each of which has different roots and
  central logs.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{
try(SLT$new()) # call with no arguments to see instructions
# Tool will not instantiate on Windows unless running with Admin permissions
# - requirement for symlink creation on Windows
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-return_dictionaries"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-return_dictionaries}{}}}
\subsection{Method \code{return_dictionaries()}}{
Return the contents of all private dictionaries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$return_dictionaries(item_names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{item_names}}{[chr] Default `NULL`.  If `NULL`, show all static
internal fields.  Otherwise, vector of static field names you want to
see.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[list] of all static internal fields
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-return_dynamic_fields"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-return_dynamic_fields}{}}}
\subsection{Method \code{return_dynamic_fields()}}{
Print the contents of all dynamic fields.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$return_dynamic_fields(item_names = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{item_names}}{[chr] Default `NULL`.  If `NULL`, show all dynamic
internal fields.  Otherwise, vector of dynamic field names you want
to see.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[std_out] Print dynamic field values to std_out.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-mark_best"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-mark_best}{}}}
\subsection{Method \code{mark_best()}}{
Mark an output folder with a "best" symlink.

Enforces:
- maximum of one best model
  - does not go back through history to make a best model from a prior version (not capable, this is what log_tool is for)

Writes:
- appends to a log file in the output folder with a date and time stamp
- appends a line to the central log file with a date and time stamp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$mark_best(version_name, user_entry)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_name}}{[chr] The directory name of the output folder that
lives directly under one of the `root`s you define when you
instantiate the tool.}

\item{\code{user_entry}}{[list] Named list of user-defined fields to append to
the log.  After making a tool called e.g. slt, call
`slt$return_dictionaries("log_fields_user")` to find which fields a
user may add.  If you want to make your own version of this class,
you may update `log_schema` in the `private$DICT` section to allow
for them.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[ste_err] Messages about actions taken.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-mark_keep"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-mark_keep}{}}}
\subsection{Method \code{mark_keep()}}{
Mark an output folder with a "keep_<version_name>" symlink

Writes:
- appends to a log file in the output folder with a date and time stamp
- appends a line to the central log file with a date and time stamp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$mark_keep(version_name, user_entry)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_name}}{[chr] The directory name of the output folder that
lives directly under one of the `root`s you define when you
instantiate the tool.}

\item{\code{user_entry}}{[list] Named list of user-defined fields to append to
the log.  After making a tool called e.g. slt, call
`slt$return_dictionaries("log_fields_user")` to find which fields a
user may add.  If you want to make your own version of this class,
you may update `log_schema` in the `private$DICT` section to allow
for them.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[std_err] Messages about actions taken.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-mark_remove"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-mark_remove}{}}}
\subsection{Method \code{mark_remove()}}{
Mark an output folder with a "remove_<version_name>" symlink

Indication that the results can be deleted
- In the future, this will be used to remove old versions of the
  output, and provide a list of ST-GPR models to delete

Writes:
- appends to a log file in the output folder with a date and time stamp
- appends a line to the central log file with a date and time stamp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$mark_remove(version_name, user_entry)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_name}}{[chr] The directory name of the output folder that
lives directly under one of the `root`s you define when you
instantiate the tool.}

\item{\code{user_entry}}{[list] Named list of user-defined fields to append to
the log.  After making a tool called e.g. slt, call
`slt$return_dictionaries("log_fields_user")` to find which fields a
user may add.  If you want to make your own version of this class,
you may update `log_schema` in the `private$DICT` section to allow
for them.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[std_err] Messages about actions taken.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-unmark"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-unmark}{}}}
\subsection{Method \code{unmark()}}{
Remove all symlinks for a single `version_name` in all `roots`

Writes:
- appends to a log file in the output folder with a date and time stamp
- does _not_ append to the central log file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$unmark(version_name, user_entry)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_name}}{[chr] The directory name of the output folder that
lives directly under one of the `root`s you define when you
instantiate the tool.}

\item{\code{user_entry}}{[list] Named list of user-defined fields to append to
the log.  After making a tool called e.g. slt, call
`slt$return_dictionaries("log_fields_user")` to find which fields a
user may add.  If you want to make your own version of this class,
you may update `log_schema` in the `private$DICT` section to allow
for them.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[std_err] Messages about the symlinks removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-roundup_best"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-roundup_best}{}}}
\subsection{Method \code{roundup_best()}}{
Find all `best_` symlinks in all `roots`

Return both the symlink and the resolved symlink (folder the symlink
points to)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$roundup_best()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
[list] list of data.tables - one for each `root`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-roundup_keep"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-roundup_keep}{}}}
\subsection{Method \code{roundup_keep()}}{
Find all `keep_` symlinks in all `roots`

Return both the symlink and the resolved symlink (folder the symlink
points to)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$roundup_keep()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
[list] list of data.tables - one for each `root`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-roundup_remove"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-roundup_remove}{}}}
\subsection{Method \code{roundup_remove()}}{
Find all `remove_` symlinks in all `roots`

Return both the symlink and the resolved symlink (folder the symlink
points to)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$roundup_remove()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
[list] list of data.tables - one for each `root`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-roundup_unmarked"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-roundup_unmarked}{}}}
\subsection{Method \code{roundup_unmarked()}}{
Find all folders without symlinks in all `roots`

Useful if you're rapidly iterating, have only marked a couple folders,
and want to remove the rest.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$roundup_unmarked()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
[list] list of data.tables - one for each `root`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-roundup_by_date"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-roundup_by_date}{}}}
\subsection{Method \code{roundup_by_date()}}{
Find all `version_name` folders by creation date

Only finds folders that _have a log_, and reads creation date on first
row.  User may select dates by (using the `date_selector` argument):
- greater than - `gt`
- greater than or equal to - `gte`
- less than - `nt`
- less than or equal to `nte`
- equal to `e`
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$roundup_by_date(user_date, date_selector)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user_date}}{[c("character", "Date", POSIXct", "POSIXt")] A date
with class requirements - must be formatted "2020-01-01 or 2020_01_01
or 2020/01/01"}

\item{\code{date_selector}}{[chr] See docstring explanation.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[list] list of data.tables - one for each `root`
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-get_common_new_version_name"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-get_common_new_version_name}{}}}
\subsection{Method \code{get_common_new_version_name()}}{
Get a new YYYY_MM_DD.VV version compatible with _ALL THE
TOOL'S ROOTS_

If root1 has 2025_01_01.01 and root2 has 2025_01_01.03, then a new
folder would need to be 2025_01_01.04
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$get_common_new_version_name(date = "today", root_list = private$DICT$ROOTS)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{[chr] Default "today".  The date to use for the new version
name.  Must be formatted "2020_01_01"}

\item{\code{root_list}}{[list] named list of root directories for pipeline}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[chr] format YYYY_MM_DD.VV
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-make_new_version_folder"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-make_new_version_folder}{}}}
\subsection{Method \code{make_new_version_folder()}}{
Create a new `version_name` folder in _ALL THE TOOL'S
  ROOTS_

  Create a new log in each folder.  No symlinks are created.  No
  `user_entry` is used.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$make_new_version_folder(version_name = self$get_common_new_version_name())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_name}}{[chr] The directory name of the
output folder that lives directly under one of the `root`s you define
when you instantiate the tool.  For convenience, user may leave NULL
(default) and `get_common_new_version_name()` is used on that root.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[std_err] Messages about the folder creation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-make_new_log"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-make_new_log}{}}}
\subsection{Method \code{make_new_log()}}{
Safely write an empty log file for first pipeline runs

When you start a new pipeline run, make an empty log
- helpful if you let this tool manage all your versions
- you can roundup version_names by creation date using the log's first entry
- the file system doesn't track directory creation dates (at time of writing)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$make_new_log(version_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_name}}{[chr] The directory name of the output folder that
lives directly under one of the `root`s you define when you
instantiate the tool.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[std_err] Messages about the log creation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-delete_version_folders"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-delete_version_folders}{}}}
\subsection{Method \code{delete_version_folders()}}{
Delete a `version_name` folder marked with a `remove_` symlink from
_ALL ITS ROOTS_

Removes the symlink(s) and the underlying folder(s), and updates
central log if folders were removed.

Writes:
- appends a line to the central log file with a date and time stamp
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$delete_version_folders(version_name, user_entry, require_user_input = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_name}}{[chr] The directory name of the output folder that
lives directly under one of the `root`s you define when you
instantiate the tool.}

\item{\code{user_entry}}{[list] Named list of user-defined fields to append to
the log.  After making a tool called e.g. slt, call
`slt$return_dictionaries("log_fields_user")` to find which fields a
user may add.  If you want to make your own version of this class,
you may update `log_schema` in the `private$DICT` section to allow
for them.}

\item{\code{require_user_input}}{[lgl] if `TRUE`, will prompt user to confirm
deletion.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
[std_err] Messages about deletion events.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-make_reports"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-make_reports}{}}}
\subsection{Method \code{make_reports()}}{
Make all reports

Writes all reports to a summary .csv for every `root` defined in the
tool.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$make_reports()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
[std_err] Messages about where reports were written.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Symlink_Tool-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Symlink_Tool-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SLT$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
