% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsr.R
\name{nsr}
\alias{nsr}
\alias{lm.nsr}
\title{Calculate Normalized Simple Ratio (NSR) index.}
\usage{
nsr(s, b1, b2)

lm.nsr(s, b1, b2, y)
}
\arguments{
\item{s}{Spectral data in the format of visa's Spectra object, spectra.dataframe or spectra.matrix.}

\item{b1}{A integer number which defines the wavelength of the 1st spectral band.}

\item{b2}{A integer number which defines the wavelength of the 2nd spectral band.}

\item{y}{A numeric variable to correlate with SR}
}
\value{
\item{nsr}{Returns a NSR index.}

\item{p}{Returns a ggplot object.}
}
\description{
It is a normalization of SR by doing NSR = (1-SR)/(1+SR), with the same two spectral bands.
}
\details{
As it exactly reads in its name, it is a normalization of the SR and ranges in (0,1).
}
\examples{
s <- NSpec.DF$spectra
nsr1 <- nsr(s, 480, 550)

s <- NSpec.DF
y <- NSpec.DF$N
lm.nsr(s,600,500,y)

}
