% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSimulation.R
\name{plotSimulation}
\alias{plotSimulation}
\title{Plots results of \code{\link{simulatePopulation}}.}
\usage{
plotSimulation(
  simulation.output = NULL,
  species = "all",
  burnin = FALSE,
  filename = NULL,
  time.zoom = NULL,
  panels = c("Driver A",
           "Driver B",
           "Suitability",
           "Population",
           "Mortality",
           "Biomass",
           "Pollen"
           ),
 plot.title = NULL,
 width = 12,
 text.size = 20,
 title.size = 25,
 line.size = 1
 )
}
\arguments{
\item{simulation.output}{output of \code{\link{simulatePopulation}}.}

\item{species}{a number or vector of numbers representing rows in the parameters dataframe, or a string or vector of strings referencing to the "label" column of the parameters dataframe.}

\item{burnin}{if \code{FALSE}, burn-in period is not considered in the model.}

\item{filename}{character string, name of output pdf file. If NULL or empty, no pdf is produced. It shouldn't include the extension of the output file.}

\item{time.zoom}{vector of two numbers indicating the beginnign and end of the time interval to be plotted (i.e. "c(5000, 10000)")}

\item{panels}{character string or vector of character strings with these possible values: "Driver A", "Driver B","Suitability", "Population", "Mortality", "Biomass", "Pollen".}

\item{plot.title}{character string to use as plot title.}

\item{width}{plot width in inches.}

\item{text.size}{text size of the plot.}

\item{title.size}{plot title size.}

\item{line.size}{size of lines in plots.}
}
\description{
This function takes as input the output of \code{\link{simulatePopulation}}, and plots the pollen abundance, number of individuals, biomass, driver, and environmnetal suitability of each simulation outcome.
}
\details{
The user can decide what virtual taxa to plot (argument \code{species}), and what information to show throught the \code{panels} argument. Output is plotted on screen by default, and printed to pdf if the \code{filename} argument is filled.
}
\examples{

#getting example data
data(simulation)

#plot first simulation
plotSimulation(simulation.output = simulation[[1]])

}
\seealso{
\code{\link{simulatePopulation}}, \code{\link{compareSimulations}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
