% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAcf.R
\name{plotAcf}
\alias{plotAcf}
\title{Plots results of \code{\link{acfToDf}}.}
\usage{
plotAcf(
  x = NULL,
  plot.title = ""
  )
}
\arguments{
\item{x}{dataframe, output of \code{\link{acfToDf}}}

\item{plot.title}{string, title of the output plot.}
}
\value{
A ggplot object
}
\description{
Plots a dataframe resulting from \code{\link{acfToDf}} by using \code{\link[ggplot2]{ggplot2}}.
}
\examples{

#getting a driver
data(driverA)

#computing temporal autocorrelations
x.df <- acfToDf(
  x = driverA,
  lag.max = 1000,
  length.out = 100
)
str(x.df)

#plotting output
plotAcf(x.df)

}
\seealso{
\code{\link{acfToDf}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
