% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_drug.R
\name{add_drug}
\alias{add_drug}
\title{Add drug column(s) to a dataset}
\usage{
add_drug(
  .data,
  d_code,
  d_names = names(d_code),
  repbasis = "sci",
  method = c("DrecNo", "MedicinalProd_Id"),
  drug_data,
  data_type = deprecated()
)
}
\arguments{
\item{.data}{The dataset used to identify individual reports (usually, it is \code{demo})}

\item{d_code}{A named list of drug codes (DrecNos or MPI). See Details.}

\item{d_names}{A character vector. Names for drug columns (must be the same length as d_code), default to \code{names(d_code)}}

\item{repbasis}{Suspect, interacting and/or concomitant.
Type initial of those you wish to select ("s" for suspect, "c" for concomitant
and "i" for interacting ; default to all, e.g. "sci").}

\item{method}{A character string. The type of drug code (DrecNo or MedicinalProd_Id). See details.}

\item{drug_data}{A data.frame containing the drug data (usually, it is \code{drug})}

\item{data_type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. Data_type is now detected
internally.}
}
\value{
A dataset with the new drug columns.
Each element of \code{d_names} will add a column with the same name in \code{.data}.
The value can be 0 (the corresponding drug is absent)
or 1 (the drug is present in the case if \code{.data} is \code{demo} or \code{adr},
or "this row correspond to this drug", if \code{.data} is \code{drug} or \code{link}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Creates drug columns.
in vigibase datasets (demo, link, adr, drug, and ind).
}
\details{
\code{d_code} is a named list containing drug codes.
Either drug record numbers (e.g., from \code{\link[=get_drecno]{get_drecno()}}), or
medicinalprod_ids (e.g., from \code{\link[=get_atc_code]{get_atc_code()}}). Default method is to DrecNos.
}
\section{Argument \code{repbasis}}{

Drugs can be reported according to one of three reputation bases:
\itemize{
\item \code{s} for suspect
\item \code{c} for concomitant
\item \code{i} for interacting
}
in the occurrence of the adverse drug reaction. To study only one of these
reputation basis, type only the corresponding letter in \code{repbasis},
e.g. "s" for suspects, or "si" for suspect \strong{or} interacting.

You can add drug identification to a \code{demo}, \code{link}, \code{adr}, \code{drug} or \code{ind}
dataset.(if working with \code{drug}, you must provide \code{drug} twice,
as \code{.data} and \code{drug_data})
}

\examples{
# create a nivolumab column in demo_

d_sel_names <- list(nivolumab = "nivolumab")

d_drecno <- get_drecno(d_sel_names,
                        mp = mp_)
demo_ <-
  add_drug(
    .data = demo_,
    d_code = d_drecno,
    method = "DrecNo",
    repbasis = "sci",
    drug_data = drug_
  )

# remember to assign the result to your actual demo dataset

# do you want to work only with cases where nivolumab was a "suspected" drug?
# change argument repbasis to "s"

demo_ <-
  add_drug(
    .data = demo_,
    d_code = d_drecno,
    d_names = "nivolumab_suspected",
    method = "DrecNo",
    repbasis = "s",
    drug_data = drug_
  )

check_dm(demo_, cols = c("nivolumab", "nivolumab_suspected"))
}
\seealso{
\code{\link[=add_adr]{add_adr()}}, \code{\link[=get_drecno]{get_drecno()}}, \code{\link[=get_atc_code]{get_atc_code()}}
}
\keyword{data_management}
\keyword{drug}
