% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moves_rpdy.R
\name{moves_rpdy}
\alias{moves_rpdy}
\title{MOVES estimation of using rates per distance by model year}
\usage{
moves_rpdy(
  veh,
  lkm,
  ef,
  source_type_id = 21,
  fuel_type_id = 1,
  pollutant_id = 91,
  road_type_id = 5,
  fuel_type,
  speed_bin,
  profile,
  vehicle,
  vehicle_type,
  fuel_subtype,
  process_id,
  net,
  path_all,
  verbose = FALSE
)
}
\arguments{
\item{veh}{"Vehicles" data-frame or list of "Vehicles" data-frame. Each data-frame
as number of columns matching the age distribution of that ype of vehicle.
The number of rows is equal to the number of streets link.}

\item{lkm}{Length of each link in miles}

\item{ef}{emission factors from EmissionRates_running exported from MOVES}

\item{source_type_id}{Number to identify type of vehicle as defined by MOVES.}

\item{fuel_type_id}{Number to identify type of fuel as defined by MOVES.}

\item{pollutant_id}{Number to identify type of pollutant as defined by MOVES.}

\item{road_type_id}{Number to identify type of road as defined by MOVES.}

\item{fuel_type}{Data.frame of fuelSubtypeID exported by MOVES.}

\item{speed_bin}{Data.frame or vector of avgSpeedBinID as defined by MOVES.}

\item{profile}{Data.frame or Matrix with nrows equal to 24 and ncol 7 day of
the week}

\item{vehicle}{Character, type of vehicle}

\item{vehicle_type}{Character, subtype of vehicle}

\item{fuel_subtype}{Character, subtype of vehicle}

\item{process_id}{Character, processID}

\item{net}{Road network class sf}

\item{path_all}{Character to export whole estimation. It is not recommended since it
is usually too heavy.}

\item{verbose}{Logical; To show more information. Not implemented yet}
}
\value{
a list with emissions at each street and data.base aggregated by categories. See \code{link{emis_post}}
}
\description{
\code{\link{moves_rpdy}} estimates running exhaust emissions
using MOVES emission factors.
}
\note{
`decoder` shows a decoder for MOVES
}
\examples{
{
data(decoder)
decoder
}
}
