% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relation2header.R
\name{relation2header}
\alias{relation2header}
\alias{relation2header.vegtable}
\alias{relation2header,vegtable-method}
\title{Insert variables from relations into header}
\usage{
relation2header(vegtable, ...)

\method{relation2header}{vegtable}(vegtable, relation, vars, ...)
}
\arguments{
\item{vegtable}{An \linkS4class{vegtable} object.}

\item{...}{Further arguments passed among methods}

\item{relation}{A character value indicating the relation to be used for
inserting new variables in slot header.}

\item{vars}{A selection of variables from the relation to be inserted in
header. This function will check the existence of the variables in the
respective relation and retrieve an error if none is matching the names.
If missing in the arguments, all variables of the respective relation
will be inserted.}
}
\value{
A \linkS4class{vegtable} object.
}
\description{
Information associated to categories listed in slot \strong{relations} can be
inserted to slot \strong{header} for further statistical comparisons.
}
\examples{
## Insert publication year of the source into header
veg <- relation2header(Kenya_veg, "REFERENCE", "YEAR")

## Show the frequency of plots per publication year
summary(as.factor(veg$YEAR))

}
\author{
Miguel Alvarez, \href{mailto:kamapu78@gmail.com}{kamapu78@gmail.com}
}
