% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osculating_circle3d.R
\name{osculating_circle3d}
\alias{osculating_circle3d}
\title{Osculating discs and circles of a spatial curve}
\usage{
osculating_circle3d(
  X,
  Y,
  Z,
  a,
  b,
  t_points,
  h = 1e-04,
  plot = FALSE,
  n_samples = 400,
  fill = c("disk", "ring"),
  ru = 24,
  rv = 72,
  colorscale = "Reds",
  opacity = 0.6,
  ring_line = list(color = "red", width = 4, dash = "solid"),
  show_curve = TRUE,
  show_points = TRUE,
  curve_line = list(color = "blue", width = 2, dash = "solid"),
  point_marker = list(color = "black", size = 3, symbol = "circle"),
  show_radius = FALSE,
  radius_phase = 0,
  radius_line = list(color = "orange", width = 5, dash = "solid"),
  scene = list(aspectmode = "data", xaxis = list(title = "x(t)"), yaxis = list(title =
    "y(t)"), zaxis = list(title = "z(t)")),
  bg = list(paper = "white", plot = "white"),
  lighting = list(ambient = 1, diffuse = 0.15, specular = 0, roughness = 1, fresnel = 0),
  tol = 1e-10
)
}
\arguments{
\item{X, Y, Z}{Functions of \code{t} returning the coordinate components
of the curve.}

\item{a, b}{Numeric endpoints of the parameter interval.}

\item{t_points}{Numeric vector of parameter values at which osculating
circles or discs are constructed.}

\item{h}{Step size for centered finite-difference approximations.}

\item{plot}{Logical; if \code{TRUE}, creates a 3D visualization using
\pkg{plotly}.}

\item{n_samples}{Number of sample points used to draw the base curve
when \code{show_curve = TRUE}.}

\item{fill}{Character; either \code{"disk"} for a filled surface or
\code{"ring"} for the circumference only.}

\item{ru}{Number of radial subdivisions when drawing a filled disc.}

\item{rv}{Number of angular subdivisions; also used as the number of
points on each ring.}

\item{colorscale}{Character string giving the \pkg{plotly} colorscale
used for the discs.}

\item{opacity}{Numeric value between 0 and 1 controlling the opacity of
the discs when \code{fill = "disk"}.}

\item{ring_line}{List with style options for the ring when
\code{fill = "ring"}.}

\item{show_curve, show_points}{Logical values indicating whether the base
curve and the corresponding points on the curve should be displayed.}

\item{curve_line, point_marker}{Lists with \pkg{plotly} style options for
the base curve and the points.}

\item{show_radius}{Logical; if \code{TRUE}, draws a radius segment from
the center of each osculating circle to its boundary.}

\item{radius_phase}{Angle, in radians, that determines the direction of
the displayed radius.}

\item{radius_line}{List with \pkg{plotly} style options for the radius
segment.}

\item{scene}{List with 3D scene settings for the \pkg{plotly} figure.}

\item{bg}{List defining background colors for the figure, typically with
entries \code{paper} and \code{plot}.}

\item{lighting}{List with lighting options for \code{add_surface} when
\code{fill = "disk"}.}

\item{tol}{Numeric tolerance used in derivative-based checks and to
detect degenerate cases in which curvature or frame vectors cannot be
computed reliably.}
}
\value{
A list with two components:
\describe{
\item{\code{data}}{A tibble with columns
\code{t, x, y, z, kappa, cx, cy, cz, radius,
    Tx, Ty, Tz, Nx, Ny, Nz, Bx, By, Bz}, containing the parameter
values, the curve coordinates, the numerical curvature, the centers
and radii of the osculating circles, and the associated Frenet frame
vectors.}
\item{\code{plot}}{A \pkg{plotly} object when \code{plot = TRUE},
otherwise \code{NULL}.}
}
}
\description{
For a three-dimensional parametric curve, this function constructs
numerical approximations to the osculating circles (and associated
discs) at a set of parameter values. At each requested point on the
curve, it approximates the Frenet frame and the curvature, and then
uses this information to define the center and radius of the local
osculating circle. Optionally, it can display these circles or discs
in an interactive 3D visualization using \pkg{plotly}.
}
\details{
For each parameter value in \code{t_points}, the function:
\itemize{
\item evaluates the curve and approximates its first and second
derivatives,
\item constructs approximate tangent, normal and binormal directions,
\item estimates the curvature from the derivative information,
\item defines the center of the osculating circle by moving from the
curve point along the normal direction by a distance equal to
the reciprocal of the curvature,
\item records the corresponding radius as that same reciprocal
quantity.
}

Depending on the value of \code{fill}, the function either:
\itemize{
\item builds a filled disc that lies in the osculating plane and is
bounded by the osculating circle, or
\item draws only the circumference corresponding to that circle.
}

A regular sampling of angles around the osculating circle is used to
generate the discrete representation. For filled discs, radial
subdivisions are added to obtain a surface mesh. The resulting objects
can be combined with a sampled version of the base curve and additional
elements such as radius segments.
}
\examples{
X <- function(t) cos(t)
Y <- function(t) sin(t)
Z <- function(t) 0.2 * t
osculating_circle3d(
  X, Y, Z,
  a = 0, b = 6 * pi,
  t_points = c(pi, 2 * pi),
  plot = FALSE
)

}
