% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/veccompare.R
\docType{package}
\name{veccompare-package}
\alias{veccompare}
\alias{veccompare-package}
\title{veccompare: Automatically Generate All n-Wise Set Comparisons on Vectors}
\description{
The \pkg{veccompare} package contains functions for automating set operations. Given a named list of 5 vectors, for example, \pkg{veccompare} can calculate all 2-, 3-, 4-, and 5-way comparisons between those vectors, recording information for each comparison about the set "union" (combined elements), "intersection" (overlap / shared elements), and compliments (which elements are unique to each vector involved in the comparison).
}
\details{
The veccompare package contains functions for automating set operations (i.e., comparisons of overlap) between multiple vectors.

The package also contains a function for automating reporting in RMarkdown, by generating markdown output for easy analysis, as well as an RMarkdown template for use with RStudio.

The primary function from \pkg{veccompare} is \code{\link{compare.vectors}}. Complementarily, \code{\link{compare.vectors.and.return.text.analysis.of.overlap}} will call \code{\link{compare.vectors}} and generate Markdown-style output from it (for example, for use within an RMarkdown file).

An RMarkdown template illustrating several of \pkg{veccompare}'s features can be used from within RStudio by clicking \code{File -> New File -> R Markdown... -> From Template -> Veccompare Overlap Report}.

\pkg{veccompare} also provides a function, \code{\link{summarize.two.way.comparisons.percentage.overlap}}, that can create correlation-plot-style images and network graphs for all two-way comparisons between vectors. This function is also demonstrated in the \code{Veccompare Overlap Report} described above.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/publicus/r-veccompare}
  \item Report bugs at \url{https://github.com/publicus/r-veccompare/issues}
}

}
\author{
\strong{Maintainer}: Jacob Gerard Levernier \email{jlevern@upenn.edu} (Designed and authored the package source code and documentation. Roles: author, creator, designer, engineer, programmer)

Authors:
\itemize{
  \item Heather Gaile Wacha \email{wacha2@wisc.edu} (Provided intellectual overview and consultation during development for use with medieval cartographic datasets. Roles: conceptor, consultant, data contributor)
}

}
