% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{v_scatter}
\alias{v_scatter}
\title{Create a Scatter Chart}
\usage{
v_scatter(
  vc,
  mapping = NULL,
  data = NULL,
  name = NULL,
  ...,
  serie_id = NULL,
  data_id = NULL
)
}
\arguments{
\item{vc}{A chart initialized with \code{\link[=vchart]{vchart()}}.}

\item{mapping}{Default list of aesthetic mappings to use for chart.}

\item{data}{Default dataset to use for chart. If not already
a \code{data.frame}, it will be coerced to with \code{as.data.frame}.}

\item{name}{Name for the serie, only used for single serie (no \code{color}/\code{fill} aesthetic supplied).}

\item{...}{Additional parameters for the serie.}

\item{data_id, serie_id}{ID for the data/serie, can be used to further customize the chart with \code{\link[=v_specs]{v_specs()}}.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Create a Scatter Chart
}
\examples{

library(vchartr)
data("penguins", package = "palmerpenguins")

# Basic scatter chart
vchart(penguins) \%>\%
  v_scatter(aes(x = flipper_length_mm, y = body_mass_g))

# Color series with discrete values
vchart(penguins) \%>\%
  v_scatter(aes(x = flipper_length_mm, y = body_mass_g, color = species))

# Color series with continuous values
vchart(penguins) \%>\%
  v_scatter(aes(x = bill_length_mm, y = bill_depth_mm, color = body_mass_g))

# Size of points
vchart(penguins) \%>\%
  v_scatter(aes(x = bill_length_mm, y = bill_depth_mm, size = body_mass_g))

# Size and color
vchart(penguins) \%>\%
  v_scatter(aes(
    x = bill_length_mm,
    y = bill_depth_mm,
    color = body_mass_g,
    size = body_mass_g
  ))

# With shapes
vchart(penguins) \%>\%
  v_scatter(
    aes(
      x = bill_length_mm,
      y = bill_depth_mm,
      color = species,
      shape = species
    )
  )



vchart(penguins) \%>\%
  v_scatter(
    aes(x = flipper_length_mm, y = body_mass_g, color = species)
  ) \%>\%
  v_scale_color_manual(c(
    Adelie = "#ffa232",
    Chinstrap = "#33a2a2",
    Gentoo = "#b34df2"
  ))
}
