% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{scale-color-manual}
\alias{scale-color-manual}
\alias{v_scale_color_manual}
\alias{v_scale_fill_manual}
\alias{v_scale_color_discrete}
\alias{v_scale_fill_discrete}
\title{Manual color scale}
\usage{
v_scale_color_manual(vc, values)

v_scale_fill_manual(vc, values)

v_scale_color_discrete(vc, palette)

v_scale_fill_discrete(vc, palette)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}} or specific chart's type function.}

\item{values}{A named list with data values as name and color as values}

\item{palette}{A color vector or the name of an R palette.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.

A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Manual color scale

Discrete color scale
}
\examples{

library(vchartr)

subset(electricity_mix, country \%in\% c("France", "Canada")) \%>\% 
  vchart() \%>\% 
  v_bar(aes(country, generation, fill = source)) \%>\% 
  v_scale_fill_manual(c(
    "oil" = "#80549f",
    "coal" = "#a68832",
    "solar" = "#d66b0d",
    "gas" = "#f20809",
    "wind" = "#72cbb7",
    "hydro" = "#2672b0",
    "nuclear" = "#e4a701"
  ))

vchart(palmerpenguins::penguins) \%>\%
  v_scatter(
    aes(x = flipper_length_mm, y = body_mass_g, color = species)
  ) \%>\%
  v_scale_color_manual(c(
    Adelie = "#ffa232",
    Chinstrap = "#33a2a2",
    Gentoo = "#b34df2"
  ))

library(vchartr)

subset(electricity_mix, country \%in\% c("France", "Canada")) \%>\% 
  vchart() \%>\% 
  v_bar(aes(country, generation, fill = source)) \%>\% 
  v_scale_fill_discrete("Okabe-Ito")

subset(electricity_mix, country \%in\% c("France", "Canada")) \%>\% 
  vchart() \%>\% 
  v_bar(aes(country, generation, fill = source)) \%>\% 
  v_scale_fill_discrete("ggplot2")

# or 
subset(electricity_mix, country \%in\% c("France", "Canada")) \%>\% 
  vchart() \%>\% 
  v_bar(aes(country, generation, fill = source)) \%>\% 
  v_scale_fill_discrete(palette.colors(palette = "ggplot2")[-1])
}
