% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format-date}
\alias{format-date}
\alias{format_date_dayjs}
\alias{format_datetime_dayjs}
\alias{label_format_date}
\alias{label_format_datetime}
\title{Format date with dayjs JavaScript library}
\usage{
format_date_dayjs(format, prefix = "", suffix = "", locale = "en")

format_datetime_dayjs(
  format,
  prefix = "",
  suffix = "",
  locale = "en",
  tz = NULL
)

label_format_date(format)

label_format_datetime(format, tz = NULL)
}
\arguments{
\item{format}{Format for dates, see \href{https://day.js.org/docs/en/display/format}{online documentation}.}

\item{prefix}{Character string to append before formatted value.}

\item{suffix}{Character string to append after formatted value.}

\item{locale}{Localization to use, for example \code{"fr"} for french,
see possible values \href{https://cdn.jsdelivr.net/npm/dayjs@1/locale.json}{online}.}

\item{tz}{Timezone to use.}
}
\value{
a \code{JS} function.
}
\description{
Format date with dayjs JavaScript library
}
\examples{

library(vchartr)



### Format date

# date in french in \%B \%y format
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(
    date_labels = format_date_dayjs("MMMM YY", locale = "fr")
  )

# date in arabic in \%A \%d \%b \%Y format
vchart(eco2mix) \%>\%
  v_line(aes(date, solar)) \%>\%
  v_scale_x_date(
    date_labels = format_date_dayjs("dddd D MMM YYYY", locale = "ar")
  )
}
