% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_tests.R
\name{register_custom_test}
\alias{register_custom_test}
\title{Register a Custom Test Function in ValidMind}
\usage{
register_custom_test(
  func,
  test_id = NULL,
  description = NULL,
  required_inputs = NULL
)
}
\arguments{
\item{func}{An R function to be registered as a custom test.}

\item{test_id}{A unique identifier for the test. If \code{NULL}, a default ID is generated based on the function name.}

\item{description}{A description of the test. If \code{NULL}, the function's \code{description} attribute is used. Defaults to "No description" if not available.}

\item{required_inputs}{A character vector specifying the required inputs for the test. If \code{NULL}, the function's formal argument names are used.}
}
\value{
The test store object containing the newly registered custom test.
}
\description{
Registers an R function as a custom test within the ValidMind testing framework, allowing it to be used as a custom metric for model validation.
}
\details{
The provided R function is converted into a Python callable using \code{\link[reticulate]{r_to_py}}. 
A Python class is then defined, inheriting from ValidMind's \code{Metric} class, which wraps this callable.
This custom test is registered within ValidMind's test store and can be used in the framework for model validation purposes.
}
\examples{
\dontrun{
# Define a custom test function in R
my_custom_metric <- function(predictions, targets) {
  # Custom metric logic
  mean(abs(predictions - targets))
}

# Register the custom test
register_custom_test(
  func = my_custom_metric,
  test_id = "custom.mae",
  description = "Custom Mean Absolute Error",
  required_inputs = c("predictions", "targets")
)
}

}
\seealso{
\code{\link[reticulate]{r_to_py}}, \code{\link[reticulate]{import_main}}, \code{\link[reticulate]{py_run_string}}
}
