% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uslopes.R
\name{uslopes}
\alias{uslopes}
\title{Estimates slopes at extremes}
\usage{
uslopes(lmObject, vars, .vcov = NULL, x.min = NULL, x.max = NULL)
}
\arguments{
\item{lmObject}{The model to be tested}

\item{vars}{A vector with the name of the linear and squared terms. Can also be provided as a formula}

\item{.vcov}{The covariance matrix to use}

\item{x.min}{Lower bound of interval. If \code{NULL}, the minimum observed in the data is used.}

\item{x.max}{Upper bound of interval. If \code{NULL}, the maximum observed in the data is used.}
}
\value{
A list with class "uslopes" containing the following components:
\item{\code{interval }}{a vector with the interval for the independent varaible.}
\item{\code{slope    }}{a vector with the slope of the relationship at the extremes.}
\item{\code{tval     }}{a vector with the t-value of the relationship at the extremes.}
\item{\code{pval     }}{a vector with the p-value from a one-sided test a the extremes of the interval.}
\item{\code{extreme  }}{the estimated extreme point of the relationship.}
}
\description{
This function estimates the slope of the relationship at the lower and upper extreme points of the independent variable
}
\details{
The function computes slopes of a quadratic relationship at the lower  and upper bound defined by \code{x.min} and \code{x.max}. Standard errors of the
estimated slopes, t-values, and p-values from a one-sided test of a flat relationship as well as the extreme point of the estimated relationship are also provided.
}
\examples{
x <- runif(100,min=-1,max=1)
xsq <- x^2
y <- x^2+rnorm(100)
mod <- lm(y~x+xsq)

uslopes(mod,c("x","xsq"))
uslopes(mod,~x+xsq,x.max=0.8)
}
\seealso{
\link{utest}
}
