% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_data}
\alias{simulate_data}
\title{Create data function}
\usage{
simulate_data(nsubjects = 10, detection_threshold = 20,
  censortime = 365, max_datapoints = 24, min_datapoints = 6,
  sd_noise = 0.1, param_noise = c(1.5, 0.1, 1.5, 0.1),
  mean_params = c(A = 10000, delta = 0.3, B = 10000, gamma = 0.03))
}
\arguments{
\item{nsubjects}{numeric value indicating the number of subjects you want to simulate data for. Default is 10.}

\item{detection_threshold}{numeric value indicating the detection threshold of the assay used to measure viral load. Measurements below this value will be assumed to represent undetectable viral load levels. Default value is 20.}

\item{censortime}{numeric value indicating the maximum time point to include in the analysis. Default value is 365.}

\item{max_datapoints}{numeric value indicating the maximum number of data points collected from any subject. Defaults to 24.}

\item{min_datapoints}{numeric value indicating the minimum number of data points collected from any subject. Defaults to 6.}

\item{sd_noise}{numeric value indicating the standard deviation level to be used when adding noise to the simulated data (on the log10 scale). Default value is 0.1}

\item{param_noise}{numeric vector indicating the standard deviation to be used when selecting parameter values (on the log scale). Order of entries should be: A, delta, B, gamma. Default value is c(1.5, 0.1, 1.5, 0.1).}

\item{mean_params}{named numeric vector indicating the mean parameter values for the subject decay curves. Default is c(A = 10000, delta = 0.3, B = 10000, gamma = 0.03).}
}
\description{
This function simulates example data that can be used to explore model fitting and plotting within the package. Subjects are assumed to be observed at regular intervals until either the end of the study or they are lost to follow up.
}
\examples{

set.seed(1234567)

simulated_data <- simulate_data(nsubjects = 20)

}
