% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitly_user_app_info.R
\name{bitly_update_user}
\alias{bitly_update_user}
\title{Update your name and/or default group ID}
\usage{
bitly_update_user(default_group_guid = NULL, name = "", showRequestURL = FALSE)
}
\arguments{
\item{default_group_guid}{- group id to change, see NOTE}

\item{name}{- username to change}

\item{showRequestURL}{- an optional T/F value to whether show URL which has been
build and requested from server. For debug purposes, default FALSE.}
}
\description{
This will overwrite your (display) username and/or group ID you belong to.
}
\note{
Applies only to the authenticated user:
Changing group/org ID is only permitted to premium users. Thus, if you are a "free" user and will try to change your
default group id to something else, you will get an error. In that case, only changing display name is permitted.
}
\section{User}{

User operations such as changing your name or fetching basic user information apply only to the authenticated user.
}

\examples{
\dontrun{
bitly_bearerToken("access token")
# this applies only for "free" users
uu <- bitly_update_user(name = "Malc")

# if you are premium user, you can additionally adjust your group id
uug <- bitly_update_user(name = "Malc", default_group_guid = "TestGroupID")
}

}
\seealso{
\url{https://dev.bitly.com/api-reference/#updateUser}
}
