% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/uptimerobot.monitor.reset.R
\name{uptimerobot.monitor.reset}
\alias{uptimerobot.monitor.reset}
\title{Reset a monitor}
\usage{
uptimerobot.monitor.reset(api.key, id)
}
\arguments{
\item{api.key}{string with a valid key for connecting to Uptimerobot API.}

\item{id}{numeric or integer with the ID of the monitor to delete.}
}
\value{
The function returns \code{TRUE} in case success. An error is thrown otherwise.
}
\description{
\code{uptimerobot.monitor.reset} remove all the statistics and logs associated to a monitor ID.
}
\examples{
\dontrun{
 # Let's assume the api.key is available into the environment variable KEY
 api.key <- Sys.getenv("KEY", "")

# Get a list of all available monitors, and take the first id
monitors.id <- uptimerobot.monitors(api.key, fields="id")[1,1]

 # Reset the stats for that monitor
 uptimerobot.monitor.reset(api.key, monitor.id)

}
}
\author{
Gabriele Baldassarre
}

