% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/uptimerobot.monitor.edit.R
\name{uptimerobot.monitor.edit}
\alias{uptimerobot.monitor.edit}
\title{Edit a monitor}
\usage{
uptimerobot.monitor.edit(api.key, id, friendly.name = NULL, url = NULL,
  activate = TRUE, subtype = NULL, port = NULL, interval = NULL,
  keyword.type = NULL, keyword.value = NULL, HTTP.username = NULL,
  HTTP.password = NULL, alert.contacts = NULL)
}
\arguments{
\item{api.key}{string with a valid key for connecting to Uptimerobot API.}

\item{id}{numeric or integer with the ID of the monitor to edit.}

\item{friendly.name}{string the friendly (screen) name of the monitor.}

\item{url}{string with the URL/IP of the monitor.}

\item{activate}{logical to set the status of the monitor. Set to \code{TRUE} to start the monitor or \code{FALSE} to put it in paused state.}

\item{subtype}{string used only for "Port monitoring" to set which pre-defined port/service is monitored or if a custom port is monitored. You can use both the friendly name (string) or the index (integer) here.}

\item{port}{string used only for "Port monitoring" to set the port monitored.}

\item{interval}{integer with the interval for the monitoring check (in minutes).}

\item{keyword.type}{required string in Keyword monitoring".}

\item{keyword.value}{string with the value of the keyword (required for keyword monitoring).}

\item{HTTP.username}{string used for password-protected web pages (HTTP Basic Auth). Set to empty string to erase the current username. Available for HTTP and keyword monitoring.}

\item{HTTP.password}{string used for password-protected web pages (HTTP Basic Auth). Set to empty string to erase the current password.Available for HTTP and keyword monitoring.}

\item{alert.contacts}{character vector or data frame with the IDs to alert each with their threshold and recurrence values.}
}
\value{
The function returns \code{TRUE} in case success. An error is thrown otherwise.
}
\description{
\code{uptimerobot.monitor.edit} edits the properties for an existing monitor.
}
\details{
If a property has not to be updated, just omit it from the parameters or set to \code{NA}.
To erase the value of a property, set it to an empty string, ie \code{""}, instead (not \code{NA} or \code{NULL}!).

The type of a monitor can not be edited (like changing a HTTP monitor into a Port monitor).

The alert contacts are whom to be notified when the monitor goes up/down.

Multiple alert contact IDs can be sent in a character vector or in a data frame. If you pass alert contact IDs in a vector, each element must be formatted in the form \code{<id>_<threshold>_<recurrence>} (note the underscores).
If you prefer to format it as a data.frame, it must have these three columns: \code{id, threshold, recurrence}, numeric or integer. Order of the columns doesn't matter.

Please note that thresholds and recurrences can be omitted (default to zero) and, as they are only available in the Pro Plan, they are always 0 in the Free Plan.
}
\examples{
\dontrun{
 # Let's assume the api.key is available into the environment variable KEY
 api.key <- Sys.getenv("KEY", "")

 # Create a monitor and get its monitor.id
 monitor.id <- uptimerobot.monitor.new(api.key,
   friendly.name="Open Analytics",
   url="https://gabrielebaldassarre.com", type="http"
 )

 # Change the friendly name of the monitor
  if(uptimerobot.monitor.edit(api.key,
     monitor.id,
     friendly.name="Open Analytics - gabrielebaldassarre.com"
  ){
   message("Monitor has been successfully edited!")
 }

 # Delete the just-made monitor
 if(uptimerobot.monitor.delete(api.key, monitor.id){
   message("Monitor has been successfully deleted!")
 }
}
}
\author{
Gabriele Baldassarre
}

