% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volumes.R
\name{volume_hexahedron}
\alias{volume_hexahedron}
\title{Hexahedron volume}
\usage{
volume_hexahedron(hexahedron)
}
\arguments{
\item{hexahedron}{a 3 times 8 matrix whose columns are the eight vertices 
of the hexahedron; see \code{\link{makeHexahedron}}}
}
\value{
The volume of the hexahedron.
}
\description{
Volume of a hexahedron.
}
\examples{
library(uniformly)
# a cube with side 2 ####
hexahedron <- makeHexahedron(
  p0 = c(0, 0, 0),
  p1 = c(2, 0, 0),
  p2 = c(2, 2, 0),
  p3 = c(0, 2, 0),
  p4 = c(0, 2, 2),
  p5 = c(0, 0, 2),
  p6 = c(2, 0, 2),
  p7 = c(2, 2, 2)
)
volume_hexahedron(hexahedron) # should be 8
}
