% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Magdeburg.R
\docType{data}
\name{uni_magdeburg_3}
\alias{uni_magdeburg_3}
\title{Medical faculty and hospital colors of the University of Magdeburg, Germany}
\format{
An object of class \code{character} of length 10.
}
\source{
Color definitions are based on the \href{https://www.ovgu.de/}{OVGU}'s 
\href{https://www.cd.ovgu.de/Logo_+Farbe_+Schrift/Farbe.html}{Corporate design} guidelines (HTML).
}
\usage{
uni_magdeburg_3
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_magdeburg_3} provides medical faculty and hospital colors 
of the \href{https://www.ovgu.de/}{Otto von Guericke University Magdeburg} (OVGU), Germany.
}
\details{
The 3 primary colors \code{Dunkelblau}, \code{Schwarz}, and \code{Weiss} 
are key elements of the visual design identity of the 
medical faculty and university hospital Magdeburg. 

Together, the colors provide a serious and progressive impression, 
corresponding to the corporate vision of the institution.
The triad forms part of the logo and other design elements. 

\code{uni_magdeburg_3} is based on RGB color definition.


While the primary colors are obligatory in every publication, 
they can be supported by 7 secondary colors. 
These bright and friendly colors provide emphasis, structure, 
and visual distinctions when balanced with the 
darker and more rational primary colors.

While the majority of all areas should be kept in the primary colors, 
the secondary colors can be used for accents and highlighting purposes.
}
\examples{
uni_magdeburg_3
unikn::seecol(uni_magdeburg_3, col_bg = "grey90", 
              main = "Medical and hospital colors of the OVGU Magdeburg")  # view palette

}
\seealso{
\code{\link{uni_magdeburg_1}} for primary colors of the OVGU Magdeburg;
\code{\link{uni_magdeburg_2}} for faculty colors of the OVGU Magdeburg;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_3_2023}},
\code{\link{fu_4}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_1}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2023-10-03.
}
\concept{German university color palettes}
\keyword{datasets}
