% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Manchester_Uni.R
\docType{data}
\name{manchester_uni_2}
\alias{manchester_uni_2}
\title{Accent colors of Manchester University, USA}
\format{
An object of class \code{character} of length 4.
}
\source{
Color definitions are based on Manchester University's 
\href{https://www.manchester.edu/about/news-media/brand-toolkit/}{marketing brand toolkit}.
}
\usage{
manchester_uni_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{manchester_uni_2} provides the three accent primary colors and 
white as suggested to use in minority ratio (3:1) against the primary colors on a canvas
of \href{https://www.manchester.edu}{Manchester University}, Indiana, USA.
}
\details{
The three accent colors are 
\code{"Manchester sunrise"} (defined as C=0 M=71 Y=100 K=0, R=255 G=108 B=12, #FF6C0C),
\code{"Manchester blue"} (defined as C=54 M=4 Y=9 K=0, R=107 G=196 B=222, #6BC4DE),
\code{"Manchester green"} (defined as C=55 M=3 Y=100 K=0, R=130 G=188 B=0, #82BC00), and
\code{"white"} (defined as #FFFFFF).

\code{manchester_uni_2} uses the HEX color definitions.


The secondary color palette of \href{https://www.manchester.edu}{Manchester University} 
adds brightness and vitality to the Manchester identity, and represents the energy of the University. 

These colors should be used in minority ratio against the primary colors on a canvas. 
Use a 3:1 ratio as a general rule.

Note that \href{https://www.manchester.edu}{Manchester University} is located in Indiana, USA, 
and not to be confused with \href{https://www.manchester.ac.uk}{University of Manchester}, England/UK.
}
\examples{
manchester_uni_2
unikn::seecol(manchester_uni_2, main = "Accent colors of Manchester University, USA",
              col_bg = "gray90")  # view color palette

}
\seealso{
\code{\link{manchester_uni_1}} for primary colors of Manchester University, IN, USA;
\code{\link{uni_manchester}} for colours of the University of Manchester, England/UK;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other U.S. university color palettes: 
\code{\link{asu_1}},
\code{\link{asu_2}},
\code{\link{asu_3}},
\code{\link{berkeley_1}},
\code{\link{berkeley_2}},
\code{\link{brown_1}},
\code{\link{brown_2}},
\code{\link{bu}},
\code{\link{caltech_1}},
\code{\link{caltech_2}},
\code{\link{caltech_3}},
\code{\link{cmu_1}},
\code{\link{cmu_2}},
\code{\link{cmu_3}},
\code{\link{columbia_1}},
\code{\link{columbia_2}},
\code{\link{columbia_3}},
\code{\link{cornell_1}},
\code{\link{cornell_2}},
\code{\link{cornell_3_accent}},
\code{\link{dartmouth_1}},
\code{\link{dartmouth_2}},
\code{\link{dartmouth_3}},
\code{\link{duke_1}},
\code{\link{duke_2}},
\code{\link{harvard_1}},
\code{\link{harvard_2}},
\code{\link{harvard_3}},
\code{\link{jhu_0}},
\code{\link{jhu_1}},
\code{\link{jhu_2}},
\code{\link{jhu_3_accent}},
\code{\link{jhu_4_gray}},
\code{\link{manchester_uni_1}},
\code{\link{michigan_1}},
\code{\link{michigan_2}},
\code{\link{minnesotatwin_1}},
\code{\link{minnesotatwin_2}},
\code{\link{mit}},
\code{\link{monash_1}},
\code{\link{monash_2}},
\code{\link{msu}},
\code{\link{northwestern_1}},
\code{\link{northwestern_2}},
\code{\link{notredame_1}},
\code{\link{notredame_2}},
\code{\link{nyu_1}},
\code{\link{nyu_2}},
\code{\link{nyu_accent}},
\code{\link{nyu_neutral}},
\code{\link{ohio_uni_1}},
\code{\link{ohio_uni_2}},
\code{\link{pitt_1}},
\code{\link{pitt_2}},
\code{\link{princeton_0}},
\code{\link{princeton_1}},
\code{\link{princeton_2}},
\code{\link{rpi_1}},
\code{\link{rpi_2}},
\code{\link{rpi_3}},
\code{\link{stanford_1}},
\code{\link{stanford_2}},
\code{\link{stanford_3}},
\code{\link{uchicago_1}},
\code{\link{uchicago_2}},
\code{\link{uci_1}},
\code{\link{uci_2}},
\code{\link{uci_3}},
\code{\link{uci_4}},
\code{\link{ucla_1}},
\code{\link{ucla_2}},
\code{\link{ucla_3}},
\code{\link{ucla_4}},
\code{\link{ucsd_1}},
\code{\link{ucsd_2}},
\code{\link{ucsd_3}},
\code{\link{uflorida_1}},
\code{\link{uflorida_2}},
\code{\link{uflorida_3}},
\code{\link{umass_1}},
\code{\link{umass_2}},
\code{\link{umass_neutrals}},
\code{\link{upenn_1}},
\code{\link{upenn_2}},
\code{\link{vanderbilt_1}},
\code{\link{vanderbilt_2}},
\code{\link{vanderbilt_3}},
\code{\link{willamette}},
\code{\link{wm_1}},
\code{\link{wm_2}},
\code{\link{wm_3}},
\code{\link{yale}},
\code{\link{yeshiva}}
}
\author{
\strong{unicol}, 2023-06-27.
}
\concept{U.S. university color palettes}
\keyword{datasets}
