% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ETH.R
\docType{data}
\name{eth_2}
\alias{eth_2}
\title{Lighter shades of the colors of the ETH Zurich, CH}
\format{
An object of class \code{character} of length 7.
}
\source{
Color definitions are based on 
\url{https://ethz.ch/de.html/staffnet/en/service/communication/corporate-design/digital-media/web-colours.html}.
}
\usage{
eth_2
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{eth_2} provides lighter shades of the default colors  
of the \href{https://ethz.ch/de.html/}{ETH Zürich}, Switzerland.
}
\details{
The primary colors of the ETH Zurich are provided by \code{\link{eth_1}}. 

The Swiss abbreviation "ETH" stands for "Eidgenössische Technische Hochschule".
}
\examples{
eth_2
unikn::seecol(eth_2, main = "Light shades of the ETH Zurich")  # view color palette
unikn::demopal(eth_2, type = 4, main = "Light shades of ETH Zürich colors")

}
\seealso{
\code{\link{eth_1}} and \code{\link{eth_3}} for alternative colors of the ETH Zurich;  
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other Swiss university color palettes: 
\code{\link{eth_1}},
\code{\link{eth_3}}
}
\author{
\strong{unicol}, 2022-12-30.
}
\concept{Swiss university color palettes}
\keyword{datasets}
